/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.portal.cms.security;

import java.io.Serializable;

/** @author Sohil Shah - sohil.shah@jboss.com - Nov 29, 2006 */
public class Criteria implements Serializable
{
   /**
    *
    */
   private long id = 0;
   private String name = null;
   private String value = null;

   /**
    *
    *
    */
   public Criteria()
   {

   }

   /**
    *
    *
    */
   public Criteria(String name, String value)
   {
      this();
      this.name = name;
      this.value = value;
   }

   /** @return  */
   public long getId()
   {
      return this.id;
   }

   /** @param key  */
   public void setId(long id)
   {
      this.id = id;
   }

   /** @return Returns the context. */
   public String getName()
   {
      return name;
   }

   /** @param context The context to set. */
   public void setName(String name)
   {
      this.name = name;
   }


   /** @return Returns the value. */
   public String getValue()
   {
      return value;
   }

   /** @param value The value to set. */
   public void setValue(String value)
   {
      this.value = value;
   }

   /**
    *
    */
   public boolean equals(Object obj)
   {
      boolean equals = false;
      if (obj instanceof Criteria)
      {
         Criteria input = (Criteria)obj;
         if (input.name.equals(this.name) && input.value.equals(this.value))
         {
            equals = true;
         }
      }
      return equals;
   }
}
