/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.workflow;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Created on : Dec 20, 2006
 *
 * @author Sohil Shah - sohil.shah@jboss.com
 */
public class ApprovePublishServlet extends HttpServlet
{
   private ApprovePublish approvePublishWorkflow = null;

   /**
    *
    */
   public void init() throws ServletException
   {
      try
      {
         super.init();
         InitialContext context = new InitialContext();
         approvePublishWorkflow = (ApprovePublish)context.lookup("java:portal/ApprovePublishWorkflow");
      }
      catch (Exception e)
      {
         throw new UnavailableException(e.toString());
      }
   }

   /**
    *
    */
   protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
   {
      this.doPost(request, response);
   }

   /**
    *
    */
   protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
   {
      try
      {
         String processId = request.getParameter("pId");
         String manager = request.getParameter("manager");
         boolean approve = request.getRequestURI().indexOf("approve") != -1;

         this.approvePublishWorkflow.processManagerResponse(
            Long.parseLong(processId), manager, approve
         );

         /**
          * TODO: this is a hack job until a decent GUI is integrated
          * with this workflow..Yes Yes, this will be based on JSP then
          */
         StringBuffer buffer = new StringBuffer();
         buffer.append("<html>\n");
         if (approve)
         {
            buffer.append("<span>The content was successfully published</span>\n");
         }
         else
         {
            buffer.append("<span>The content publish request was rejected</span>\n");
         }
         buffer.append("</html>\n");

         response.getWriter().write(buffer.toString());
         response.getWriter().flush();
      }
      catch (Exception e)
      {
         response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, e.toString());
      }
   }
}
