/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.workflow;

import java.io.Serializable;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created on : Dec 20, 2006
 *
 * @author Sohil Shah - sohil.shah@jboss.com
 */
public class Content implements Serializable
{

   private String path = null;
   private String userName = null;
   private String mimeType = null;
   private int size = 0;
   private Date creationDate = null;

   private String processId = null;

   /**
    *
    *
    */
   public Content()
   {

   }

   /** @return the path */
   public String getPath()
   {
      return path;
   }

   /** @param path the path to set */
   public void setPath(String path)
   {
      this.path = path;
   }

   /** @return the userName */
   public String getUserName()
   {
      return userName;
   }

   /** @param userName the userName to set */
   public void setUserName(String userName)
   {
      this.userName = userName;
   }

   /** @return the mimeType */
   public String getMimeType()
   {
      return mimeType;
   }

   /** @param mimeType the mimeType to set */
   public void setMimeType(String mimeType)
   {
      this.mimeType = mimeType;
   }

   /** @return the size */
   public int getSize()
   {
      return size;
   }

   /** @param size the size to set */
   public void setSize(int size)
   {
      this.size = size;
   }

   public String getSizeStr()
   {
      return String.valueOf((this.size / 1024)) + "kb";
   }

   /** @return the creationDate */
   public Date getCreationDate()
   {
      return creationDate;
   }

   /** @param creationDate the creationDate to set */
   public void setCreationDate(Date creationDate)
   {
      this.creationDate = creationDate;
   }

   public String getCreationDateStr()
   {
      String date = "";
      if (this.creationDate != null)
      {
         Format formatter = new SimpleDateFormat("MM/dd/yy HH:mm");
         date = formatter.format(this.creationDate);
      }
      return date;
   }

   /** @return  */
   public String getProcessId()
   {
      return processId;
   }

   /** @param processId  */
   public void setProcessId(String processId)
   {
      this.processId = processId;
   }
}
