/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms;

public class CMSException
extends RuntimeException {
    private static final long serialVersionUID = 3646107693814633408L;
    public static final int INVALID_ARCHIVE = 1;
    public static final int SERVICE_UNAVAILABLE = 2;
    private int errorCode = 0;

    public CMSException() {
    }

    public CMSException(String message) {
        super(message);
    }

    public CMSException(String message, Throwable cause) {
        super(message, cause);
    }

    public CMSException(Throwable cause) {
        super(cause);
    }

    public CMSException(int errorCode) {
        this.errorCode = errorCode;
    }

    public boolean hasPathFormatFailure() {
        boolean pathFormatFailure = false;
        if (this.getMessage().indexOf("is not a legal path element") != -1 || this.getMessage().indexOf("is not a valid path") != -1) {
            pathFormatFailure = true;
        }
        return pathFormatFailure;
    }

    public boolean isServiceUnavailable() {
        return this.errorCode == 2;
    }

    public String getMessageKey() {
        String key = "";
        switch (this.errorCode) {
            case 1: {
                key = "INVALID_ARCHIVE_MESSAGE";
                break;
            }
            case 2: {
                key = "SERVICE_UNAVAILABLE";
                break;
            }
            default: {
                key = "";
            }
        }
        return key;
    }
}

