/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.xml.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CMSMimeMappings {
    private static final String MAPPINGS_FILE = "org/jboss/portal/cms/mime-mappings.xml";
    private final HashMap mappings = new HashMap();

    public CMSMimeMappings() {
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(MAPPINGS_FILE);
            Document dmt = XMLTools.getDocumentBuilderFactory().newDocumentBuilder().parse(is);
            Element docElmt = dmt.getDocumentElement();
            List mappingsList = XMLTools.getChildren((Element)docElmt, (String)"mime-mapping");
            for (int i = 0; i < mappingsList.size(); ++i) {
                Element mapping = (Element)mappingsList.get(i);
                String extension = XMLTools.asString((Element)XMLTools.getUniqueChild((Element)mapping, (String)"extension", (boolean)true));
                String mimeType = XMLTools.asString((Element)XMLTools.getUniqueChild((Element)mapping, (String)"mime-type", (boolean)true));
                this.mappings.put(extension, mimeType);
            }
        }
        catch (Exception e) {
            try {
                throw new Error("Cannot load mime mapping file", e);
            }
            catch (Throwable throwable) {
                IOTools.safeClose(is);
                throw throwable;
            }
        }
        IOTools.safeClose((Closeable)is);
    }

    public String getMimeType(String fileExtension) {
        return (String)this.mappings.get(fileExtension);
    }
}

