/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.hibernate.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServer;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.FileSystemBLOBStore;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jboss.cache.CacheException;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.portal.cms.hibernate.state.Base;
import org.jboss.portal.cms.hibernate.state.PortalCMSCacheLoader;
import org.jboss.portal.cms.hibernate.state.VersionBinVal;
import org.jboss.portal.cms.hibernate.state.VersionNode;
import org.jboss.portal.cms.hibernate.state.VersionProp;
import org.jboss.portal.cms.hibernate.state.VersionRefs;
import org.jboss.portal.cms.hibernate.state.WSPBinVal;
import org.jboss.portal.cms.hibernate.state.WSPNode;
import org.jboss.portal.cms.hibernate.state.WSPProp;
import org.jboss.portal.cms.hibernate.state.WSPRefs;
import org.jboss.portal.cms.util.HibernateUtil;
import org.jboss.portal.common.io.IOTools;

public class JBossCachePersistenceManager
implements PersistenceManager {
    private static Logger log = Logger.getLogger(JBossCachePersistenceManager.class);
    protected static final String SCHEMA_OBJECT_PREFIX_VARIABLE = "${schemaObjectPrefix}";
    protected boolean initialized = false;
    protected String jndiName = null;
    protected String schemaObjectPrefix = "";
    protected boolean externalBLOBs = true;
    protected static final int INITIAL_BUFFER_SIZE = 1024;
    protected String blobSelect = null;
    protected String blobSelectData = null;
    protected String blobSelectExist = null;
    protected String nodeBinValSelect = null;
    protected FileSystem blobFS = null;
    protected BLOBStore blobStore = null;
    private static TreeCacheMBean pmCache = null;
    private static boolean preloaded = false;

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String JNDIName) {
        this.jndiName = JNDIName;
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix;
    }

    public boolean isExternalBLOBs() {
        return this.externalBLOBs;
    }

    public void setExternalBLOBs(boolean externalBLOBs) {
        this.externalBLOBs = externalBLOBs;
    }

    public void setExternalBLOBs(String externalBLOBs) {
        this.externalBLOBs = Boolean.valueOf(externalBLOBs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(PMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.nodeBinValSelect = "from " + this.schemaObjectPrefix + "BinVal where BINVAL_ID = ?";
        if (this.externalBLOBs) {
            LocalFileSystem blobFS = new LocalFileSystem();
            blobFS.setRoot(new File(context.getHomeDir(), "blobs"));
            blobFS.init();
            this.blobFS = blobFS;
            this.blobStore = new FileSystemBLOBStore((FileSystem)blobFS);
        } else {
            this.blobStore = new DbBLOBStore();
            this.blobSelect = "from " + this.schemaObjectPrefix + "BinVal where BINVAL_ID = ?";
            this.blobSelectData = "select data from " + this.schemaObjectPrefix + "BinVal where BINVAL_ID = ?";
            this.blobSelectExist = "select 1 from " + this.schemaObjectPrefix + "BinVal where BINVAL_ID = ?";
        }
        this.initialized = true;
        try {
            if (pmCache == null) {
                try {
                    MBeanServer server = MBeanServerLocator.locateJBoss();
                    pmCache = (TreeCacheMBean)MBeanProxyExt.create(TreeCacheMBean.class, (String)"cms.pm.cache:service=TreeCache", (MBeanServer)server);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (pmCache == null) {
                    InputStream is = null;
                    try {
                        pmCache = new TreeCache();
                        PropertyConfigurator configurator = new PropertyConfigurator();
                        is = JBossCachePersistenceManager.class.getClassLoader().getResourceAsStream("pm-cache.xml");
                        configurator.configure((Object)pmCache, is);
                        pmCache.createService();
                        pmCache.startService();
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
            }
            if (!preloaded) {
                JBossCachePersistenceManager.loadProperties(this.jndiName);
                log.info((Object)"-------------------------------------------------");
                log.info((Object)"JBossCachePersistenceManager is fully loaded.....");
                log.info((Object)"-------------------------------------------------");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized void loadProperties(String hibernateJndiName) throws Exception {
        if (preloaded) {
            return;
        }
        log.info((Object)"Pre-loading the PersistenceManager Cache in the background (started).......");
        CacheLoader wspProp = new CacheLoader("from org.jboss.portal.cms.hibernate.state.WSPProp", "/wsp_prop", hibernateJndiName);
        Thread wspPropLoader = new Thread(wspProp);
        CacheLoader versionProp = new CacheLoader("from org.jboss.portal.cms.hibernate.state.VersionProp", "/version_prop", hibernateJndiName);
        Thread versionPropLoader = new Thread(versionProp);
        CacheLoader wspNode = new CacheLoader("from org.jboss.portal.cms.hibernate.state.WSPNode", "/wsp_node", hibernateJndiName);
        Thread wspNodeLoader = new Thread(wspNode);
        CacheLoader versionNode = new CacheLoader("from org.jboss.portal.cms.hibernate.state.VersionNode", "/version_node", hibernateJndiName);
        Thread versionNodeLoader = new Thread(versionNode);
        CacheLoader wspRef = new CacheLoader("from org.jboss.portal.cms.hibernate.state.WSPRefs", "/wsp_ref", hibernateJndiName);
        Thread wspRefLoader = new Thread(wspRef);
        CacheLoader versionRef = new CacheLoader("from org.jboss.portal.cms.hibernate.state.VersionRefs", "/version_ref", hibernateJndiName);
        Thread versionRefLoader = new Thread(versionRef);
        wspPropLoader.start();
        versionPropLoader.start();
        wspNodeLoader.start();
        versionNodeLoader.start();
        wspRefLoader.start();
        versionRefLoader.start();
        while (!(wspProp.done && versionProp.done && wspNode.done && versionNode.done && wspRef.done && versionRef.done)) {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        preloaded = true;
    }

    public boolean exists(NodeId node) throws ItemStateException {
        try {
            boolean exists = false;
            String nodeId = node.toString();
            if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                Object o = pmCache.get("/wsp_node/" + PortalCMSCacheLoader.parseNodeName(nodeId), (Object)nodeId);
                if (o != null) {
                    exists = true;
                }
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                Object o = pmCache.get("/version_node/" + PortalCMSCacheLoader.parseNodeName(nodeId), (Object)nodeId);
                if (o != null) {
                    exists = true;
                }
            }
            return exists;
        }
        catch (CacheException ce) {
            throw new RuntimeException(ce);
        }
    }

    public NodeState load(NodeId node) throws NoSuchItemStateException, ItemStateException {
        try {
            Object o;
            NodeState nodeState = null;
            String nodeId = node.toString();
            byte[] nodeData = null;
            if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                o = pmCache.get("/wsp_node/" + PortalCMSCacheLoader.parseNodeName(nodeId), (Object)nodeId);
                nodeData = ((WSPNode)o).getData();
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                o = pmCache.get("/version_node/" + PortalCMSCacheLoader.parseNodeName(nodeId), (Object)nodeId);
                nodeData = ((VersionNode)o).getData();
            }
            if (nodeData != null) {
                Session session = HibernateUtil.getSessionFactory(this.jndiName).getCurrentSession();
                session.beginTransaction();
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(nodeData);
                    nodeState = this.createNew(node);
                    Serializer.deserialize((NodeState)nodeState, (InputStream)in);
                    IOTools.safeClose((Closeable)in);
                }
                catch (Exception e) {
                    session.getTransaction().rollback();
                    if (e instanceof NoSuchItemStateException) {
                        throw (NoSuchItemStateException)e;
                    }
                    String msg = "failed to read node state from cache: " + node.toString();
                    log.error((Object)msg, (Throwable)e);
                    throw new ItemStateException(msg, (Throwable)e);
                }
            }
            return nodeState;
        }
        catch (CacheException ce) {
            throw new RuntimeException(ce);
        }
    }

    private void store(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            Serializer.serialize((NodeState)state, (OutputStream)out);
            if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                VersionNode versionNode = new VersionNode(state.getId().toString(), out.toByteArray());
                versionNode.resetCacheItemPersistence();
                String cacheNode = "/version_node/" + PortalCMSCacheLoader.parseNodeName(versionNode.getNodeId());
                pmCache.put(cacheNode, (Object)versionNode.getNodeId(), (Object)versionNode);
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                WSPNode wspNode = new WSPNode(state.getId().toString(), out.toByteArray());
                wspNode.resetCacheItemPersistence();
                String cacheNode = "/wsp_node/" + PortalCMSCacheLoader.parseNodeName(wspNode.getNodeId());
                pmCache.put(cacheNode, (Object)wspNode.getNodeId(), (Object)wspNode);
            }
        }
        catch (Exception e) {
            String msg = "failed to write node state: " + state.getId();
            log.error((Object)msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void update(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            Serializer.serialize((NodeState)state, (OutputStream)out);
            String id = state.getId().toString();
            String cacheNodeName = PortalCMSCacheLoader.parseNodeName(id);
            if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                VersionNode versionNode = (VersionNode)pmCache.get("/version_node/" + cacheNodeName, (Object)id);
                if (versionNode == null) {
                    throw new Exception("No such Node: " + state.getId());
                }
                versionNode.setData(out.toByteArray());
                versionNode.resetCacheItemPersistence();
                pmCache.put("/version_node/" + cacheNodeName, (Object)id, (Object)versionNode);
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                WSPNode wspNode = (WSPNode)pmCache.get("/wsp_node/" + cacheNodeName, (Object)id);
                if (wspNode == null) {
                    throw new Exception("No such Node: " + state.getId());
                }
                wspNode.setData(out.toByteArray());
                wspNode.resetCacheItemPersistence();
                pmCache.put("/wsp_node/" + cacheNodeName, (Object)id, (Object)wspNode);
            }
        }
        catch (Exception e) {
            String msg = "failed to write node state: " + state.getId();
            log.error((Object)msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void destroy(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String id = state.getId().toString();
        String cacheNodeName = PortalCMSCacheLoader.parseNodeName(id);
        try {
            if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                pmCache.remove("/version_node/" + cacheNodeName, (Object)id);
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                pmCache.remove("/wsp_node/" + cacheNodeName, (Object)id);
            }
        }
        catch (Exception e) {
            String msg = "failed to delete node state: " + state.getId();
            log.error((Object)msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    public boolean exists(PropertyId property) throws ItemStateException {
        try {
            boolean exists = false;
            String propId = property.toString();
            if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                Object o = pmCache.get("/wsp_prop/" + PortalCMSCacheLoader.parseNodeName(propId), (Object)propId);
                if (o != null) {
                    exists = true;
                }
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                Object o = pmCache.get("/version_prop/" + PortalCMSCacheLoader.parseNodeName(propId), (Object)propId);
                if (o != null) {
                    exists = true;
                }
            }
            return exists;
        }
        catch (CacheException ce) {
            throw new RuntimeException(ce);
        }
    }

    public PropertyState load(PropertyId property) throws NoSuchItemStateException, ItemStateException {
        try {
            Object o;
            PropertyState propertyState = null;
            String propId = property.toString();
            byte[] propertyData = null;
            if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                o = pmCache.get("/wsp_prop/" + PortalCMSCacheLoader.parseNodeName(propId), (Object)propId);
                propertyData = ((WSPProp)o).getData();
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                o = pmCache.get("/version_prop/" + PortalCMSCacheLoader.parseNodeName(propId), (Object)propId);
                propertyData = ((VersionProp)o).getData();
            }
            if (propertyData != null) {
                Session session = HibernateUtil.getSessionFactory(this.jndiName).getCurrentSession();
                session.beginTransaction();
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(propertyData);
                    propertyState = this.createNew(property);
                    Serializer.deserialize((PropertyState)propertyState, (InputStream)in, (BLOBStore)this.blobStore);
                    IOTools.safeClose((Closeable)in);
                }
                catch (Exception e) {
                    session.getTransaction().rollback();
                    if (e instanceof NoSuchItemStateException) {
                        throw (NoSuchItemStateException)e;
                    }
                    String msg = "failed to read property state from cache: " + property.toString();
                    log.error((Object)msg, (Throwable)e);
                    throw new ItemStateException(msg, (Throwable)e);
                }
            }
            return propertyState;
        }
        catch (CacheException ce) {
            throw new RuntimeException(ce);
        }
    }

    private void store(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            Serializer.serialize((PropertyState)state, (OutputStream)out, (BLOBStore)this.blobStore);
            if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                VersionProp versionProp = new VersionProp(state.getId().toString(), out.toByteArray());
                versionProp.resetCacheItemPersistence();
                String cacheNode = "/version_prop/" + PortalCMSCacheLoader.parseNodeName(versionProp.getPropId());
                pmCache.put(cacheNode, (Object)versionProp.getPropId(), (Object)versionProp);
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                WSPProp wspProp = new WSPProp(state.getId().toString(), out.toByteArray());
                wspProp.resetCacheItemPersistence();
                String cacheNode = "/wsp_prop/" + PortalCMSCacheLoader.parseNodeName(wspProp.getPropId());
                pmCache.put(cacheNode, (Object)wspProp.getPropId(), (Object)wspProp);
            }
        }
        catch (Exception e) {
            String msg = "failed to write property state: " + state.getId();
            log.error((Object)msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void update(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            Serializer.serialize((PropertyState)state, (OutputStream)out, (BLOBStore)this.blobStore);
            String id = state.getId().toString();
            String cacheNodeName = PortalCMSCacheLoader.parseNodeName(id);
            if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                VersionProp versionProp = (VersionProp)pmCache.get("/version_prop/" + cacheNodeName, (Object)id);
                if (versionProp == null) {
                    throw new Exception("No such Property: " + state.getId());
                }
                versionProp.setData(out.toByteArray());
                versionProp.resetCacheItemPersistence();
                pmCache.put("/version_prop/" + cacheNodeName, (Object)id, (Object)versionProp);
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                WSPProp wspProp = (WSPProp)pmCache.get("/wsp_prop/" + cacheNodeName, (Object)id);
                if (wspProp == null) {
                    throw new Exception("No such Property: " + state.getId());
                }
                wspProp.setData(out.toByteArray());
                wspProp.resetCacheItemPersistence();
                pmCache.put("/wsp_prop/" + cacheNodeName, (Object)id, (Object)wspProp);
            }
        }
        catch (Exception e) {
            String msg = "failed to write property state: " + state.getId();
            log.error((Object)msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void destroy(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        InternalValue[] values = state.getValues();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                InternalValue val = values[i];
                if (val == null || val.getType() != 2) continue;
                BLOBFileValue blobVal = (BLOBFileValue)val.internalValue();
                blobVal.delete(true);
                String blobId = this.blobStore.createId((PropertyId)state.getId(), i);
                try {
                    this.blobStore.remove(blobId);
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)("failed to remove from BLOBStore: " + blobId), (Throwable)e);
                }
            }
        }
        String id = state.getId().toString();
        String cacheNodeName = PortalCMSCacheLoader.parseNodeName(id);
        try {
            if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                pmCache.remove("/version_prop/" + cacheNodeName, (Object)id);
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                pmCache.remove("/wsp_prop/" + cacheNodeName, (Object)id);
            }
        }
        catch (Exception e) {
            String msg = "failed to delete property state: " + state.getId();
            log.error((Object)msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    public boolean exists(NodeReferencesId targetId) throws ItemStateException {
        try {
            boolean exists = false;
            String nodeId = targetId.toString();
            if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                Object o = pmCache.get("/wsp_ref/" + PortalCMSCacheLoader.parseNodeName(nodeId), (Object)nodeId);
                if (o != null) {
                    exists = true;
                }
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                Object o = pmCache.get("/version_ref/" + PortalCMSCacheLoader.parseNodeName(nodeId), (Object)nodeId);
                if (o != null) {
                    exists = true;
                }
            }
            return exists;
        }
        catch (CacheException ce) {
            throw new RuntimeException(ce);
        }
    }

    public NodeReferences load(NodeReferencesId targetId) throws NoSuchItemStateException, ItemStateException {
        try {
            Object o;
            NodeReferences refs = null;
            String nodeId = targetId.toString();
            byte[] nodeData = null;
            if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                o = pmCache.get("/wsp_ref/" + PortalCMSCacheLoader.parseNodeName(nodeId), (Object)nodeId);
                if (o == null || !(o instanceof Base)) {
                    throw new NoSuchItemStateException(targetId.toString());
                }
                nodeData = ((WSPRefs)o).getData();
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                o = pmCache.get("/version_ref/" + PortalCMSCacheLoader.parseNodeName(nodeId), (Object)nodeId);
                if (o == null || !(o instanceof Base)) {
                    throw new NoSuchItemStateException(targetId.toString());
                }
                nodeData = ((VersionRefs)o).getData();
            }
            if (nodeData != null) {
                Session session = HibernateUtil.getSessionFactory(this.jndiName).getCurrentSession();
                session.beginTransaction();
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(nodeData);
                    refs = new NodeReferences(targetId);
                    Serializer.deserialize((NodeReferences)refs, (InputStream)in);
                    IOTools.safeClose((Closeable)in);
                }
                catch (Exception e) {
                    session.getTransaction().rollback();
                    if (e instanceof NoSuchItemStateException) {
                        throw (NoSuchItemStateException)e;
                    }
                    String msg = "failed to read reference from cache: " + targetId.toString();
                    log.error((Object)msg, (Throwable)e);
                    throw new ItemStateException(msg, (Throwable)e);
                }
            }
            return refs;
        }
        catch (CacheException ce) {
            throw new RuntimeException(ce);
        }
    }

    private void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            Serializer.serialize((NodeReferences)refs, (OutputStream)out);
            if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                VersionRefs versionRefs = new VersionRefs(refs.getId().toString(), out.toByteArray());
                versionRefs.resetCacheItemPersistence();
                String cacheNode = "/version_ref/" + PortalCMSCacheLoader.parseNodeName(versionRefs.getRefId());
                pmCache.put(cacheNode, (Object)versionRefs.getRefId(), (Object)versionRefs);
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                WSPRefs wspRefs = new WSPRefs(refs.getId().toString(), out.toByteArray());
                wspRefs.resetCacheItemPersistence();
                String cacheNode = "/wsp_ref/" + PortalCMSCacheLoader.parseNodeName(wspRefs.getRefId());
                pmCache.put(cacheNode, (Object)wspRefs.getRefId(), (Object)wspRefs);
            }
        }
        catch (Exception e) {
            String msg = "failed to write reference state: " + refs.getId();
            log.error((Object)msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void destroy(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String id = refs.getId().toString();
        String cacheNodeName = PortalCMSCacheLoader.parseNodeName(id);
        try {
            if (this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                pmCache.remove("/version_ref/" + cacheNodeName, (Object)id);
            } else if (this.schemaObjectPrefix.equalsIgnoreCase("wsp")) {
                pmCache.remove("/wsp_ref/" + cacheNodeName, (Object)id);
            }
        }
        catch (Exception e) {
            String msg = "failed to delete reference state: " + refs.getId();
            log.error((Object)msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (pmCache != null) {
            pmCache.stopService();
            pmCache.destroyService();
            pmCache = null;
            preloaded = false;
        }
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            if (this.externalBLOBs) {
                this.blobFS.close();
                this.blobFS = null;
            }
            this.blobStore = null;
        }
        finally {
            this.initialized = false;
        }
    }

    public NodeState createNew(NodeId id) {
        return new NodeState(id, null, null, 4, false);
    }

    public PropertyState createNew(PropertyId id) {
        return new PropertyState(id, 4, false);
    }

    public void store(ChangeLog changeLog) throws ItemStateException {
        Session session = HibernateUtil.getSessionFactory(this.jndiName).getCurrentSession();
        session.beginTransaction();
        try {
            this.storeHB(changeLog);
        }
        catch (ItemStateException e) {
            session.getTransaction().rollback();
            throw e;
        }
    }

    public void storeHB(ChangeLog changeLog) throws ItemStateException {
        ItemState state;
        Iterator iter = changeLog.deletedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode()) {
                this.destroy((NodeState)state);
                continue;
            }
            this.destroy((PropertyState)state);
        }
        iter = changeLog.addedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode()) {
                this.store((NodeState)state);
                continue;
            }
            this.store((PropertyState)state);
        }
        iter = changeLog.modifiedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode()) {
                this.update((NodeState)state);
                continue;
            }
            this.update((PropertyState)state);
        }
        iter = changeLog.modifiedRefs();
        while (iter.hasNext()) {
            NodeReferences refs = (NodeReferences)iter.next();
            if (refs.hasReferences()) {
                this.store(refs);
                continue;
            }
            if (!this.exists(refs.getId())) continue;
            this.destroy(refs);
        }
    }

    protected boolean exists(String blobid) throws ItemStateException {
        return this.exists(this.blobSelectExist, blobid);
    }

    private boolean exists(String query, String id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        Session session = HibernateUtil.getSessionFactory(this.jndiName).getCurrentSession();
        session.beginTransaction();
        try {
            List rs = session.createQuery(query).setString(0, id).list();
            Iterator iter = rs.iterator();
            return iter.hasNext();
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            String msg = "failed to check existence of node state: " + id;
            log.error((Object)msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    protected void logException(String message, SQLException se) {
        if (message != null) {
            log.error((Object)message);
        }
        log.error((Object)("    reason: " + se.getMessage()));
        log.error((Object)("state/code: " + se.getSQLState() + "/" + se.getErrorCode()));
        log.debug((Object)"      dump:", (Throwable)se);
    }

    class DbBLOBStore
    implements BLOBStore {
        DbBLOBStore() {
        }

        public String createId(PropertyId id, int index) {
            StringBuffer sb = new StringBuffer();
            sb.append(id.toString());
            sb.append('[');
            sb.append(index);
            sb.append(']');
            return sb.toString();
        }

        public InputStream get(String blobId) throws Exception {
            Session session = HibernateUtil.getSessionFactory(JBossCachePersistenceManager.this.jndiName).getCurrentSession();
            session.beginTransaction();
            try {
                List rs = session.createQuery(JBossCachePersistenceManager.this.blobSelectData).setString(0, blobId).list();
                Iterator iter = rs.iterator();
                ByteArrayInputStream is = null;
                Blob blob = (Blob)iter.next();
                InputStream blobStream = blob.getBinaryStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int bytesRead = -1;
                while ((bytesRead = blobStream.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                    bos.flush();
                }
                try {
                    blobStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                is = new ByteArrayInputStream(bos.toByteArray());
                return is;
            }
            catch (Exception e) {
                session.getTransaction().rollback();
                if (e instanceof NoSuchItemStateException) {
                    throw (NoSuchItemStateException)e;
                }
                String msg = "failed to read binary data: " + blobId;
                log.error((Object)msg, (Throwable)e);
                throw new ItemStateException(msg, (Throwable)e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void put(String blobId, InputStream in, long size) throws Exception {
            boolean update = JBossCachePersistenceManager.this.exists(blobId);
            Session session = HibernateUtil.getSessionFactory(JBossCachePersistenceManager.this.jndiName).getCurrentSession();
            session.beginTransaction();
            if (update) {
                try {
                    Query query = session.createQuery(JBossCachePersistenceManager.this.blobSelect);
                    if (JBossCachePersistenceManager.this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                        query.setString(0, blobId);
                        VersionBinVal versionNode = (VersionBinVal)query.uniqueResult();
                        if (versionNode == null) {
                            throw new Exception("No such Node: " + blobId);
                        }
                        versionNode.setId(blobId);
                        versionNode.setData(Hibernate.createBlob((InputStream)in));
                        session.flush();
                        return;
                    }
                    if (!JBossCachePersistenceManager.this.schemaObjectPrefix.equalsIgnoreCase("wsp")) return;
                    query.setString(0, blobId);
                    WSPBinVal wspNode = (WSPBinVal)query.uniqueResult();
                    if (wspNode == null) {
                        throw new Exception("No such Node: " + blobId);
                    }
                    wspNode.setId(blobId);
                    wspNode.setData(Hibernate.createBlob((InputStream)in));
                    session.flush();
                    return;
                }
                catch (Exception e) {
                    session.getTransaction().rollback();
                    String msg = "failed to write node state: " + blobId;
                    log.error((Object)msg, (Throwable)e);
                    throw new ItemStateException(msg, (Throwable)e);
                }
            }
            try {
                if (JBossCachePersistenceManager.this.schemaObjectPrefix.equalsIgnoreCase("version")) {
                    VersionBinVal versionNode = new VersionBinVal(blobId, Hibernate.createBlob((InputStream)in));
                    session.save((Object)versionNode);
                    session.flush();
                    return;
                } else {
                    if (!JBossCachePersistenceManager.this.schemaObjectPrefix.equalsIgnoreCase("wsp")) return;
                    WSPBinVal wspNode = new WSPBinVal(blobId, Hibernate.createBlob((InputStream)in));
                    session.save((Object)wspNode);
                    session.flush();
                }
                return;
            }
            catch (Exception e) {
                session.getTransaction().rollback();
                String msg = "failed to write node state: " + blobId;
                log.error((Object)msg, (Throwable)e);
                throw new ItemStateException(msg, (Throwable)e);
            }
        }

        public boolean remove(String blobId) throws Exception {
            Session session = HibernateUtil.getSessionFactory(JBossCachePersistenceManager.this.jndiName).getCurrentSession();
            session.beginTransaction();
            try {
                Query query = session.createQuery(JBossCachePersistenceManager.this.nodeBinValSelect).setString(0, blobId);
                Object result = query.uniqueResult();
                if (result != null) {
                    session.delete(result);
                }
                return true;
            }
            catch (Exception e) {
                session.getTransaction().rollback();
                String msg = "failed to delete binval: " + blobId;
                log.error((Object)msg, (Throwable)e);
                throw new ItemStateException(msg, (Throwable)e);
            }
        }
    }

    private static class CacheLoader
    implements Runnable {
        private static final String wspProp = "from org.jboss.portal.cms.hibernate.state.WSPProp";
        private static final String versionProp = "from org.jboss.portal.cms.hibernate.state.VersionProp";
        private static final String wspNode = "from org.jboss.portal.cms.hibernate.state.WSPNode";
        private static final String versionNode = "from org.jboss.portal.cms.hibernate.state.VersionNode";
        private static final String wspRef = "from org.jboss.portal.cms.hibernate.state.WSPRefs";
        private static final String versionRef = "from org.jboss.portal.cms.hibernate.state.VersionRefs";
        private String nodeQuery = null;
        private String nodePrefix = null;
        private boolean done = false;
        private String hibernateJndiName = null;

        private CacheLoader(String nodeQuery, String nodePrefix, String hibernateJndiName) {
            this.nodeQuery = nodeQuery;
            this.nodePrefix = nodePrefix;
            this.hibernateJndiName = hibernateJndiName;
        }

        public void run() {
            Session session = null;
            Transaction tx = null;
            try {
                session = HibernateUtil.getSessionFactory(this.hibernateJndiName).openSession();
                tx = session.beginTransaction();
                List rs = session.createQuery(this.nodeQuery).list();
                if (rs != null) {
                    for (Base cour : rs) {
                        String node;
                        cour.disableCacheItemPersistence();
                        if (cour instanceof WSPProp) {
                            node = this.nodePrefix + "/" + PortalCMSCacheLoader.parseNodeName(((WSPProp)cour).getPropId());
                            pmCache.put(node, (Object)((WSPProp)cour).getPropId(), (Object)cour);
                            continue;
                        }
                        if (cour instanceof VersionProp) {
                            node = this.nodePrefix + "/" + PortalCMSCacheLoader.parseNodeName(((VersionProp)cour).getPropId());
                            pmCache.put(node, (Object)((VersionProp)cour).getPropId(), (Object)cour);
                            continue;
                        }
                        if (cour instanceof WSPNode) {
                            node = this.nodePrefix + "/" + PortalCMSCacheLoader.parseNodeName(((WSPNode)cour).getNodeId());
                            pmCache.put(node, (Object)((WSPNode)cour).getNodeId(), (Object)cour);
                            continue;
                        }
                        if (cour instanceof VersionNode) {
                            node = this.nodePrefix + "/" + PortalCMSCacheLoader.parseNodeName(((VersionNode)cour).getNodeId());
                            pmCache.put(node, (Object)((VersionNode)cour).getNodeId(), (Object)cour);
                            continue;
                        }
                        if (cour instanceof WSPRefs) {
                            node = this.nodePrefix + "/" + PortalCMSCacheLoader.parseNodeName(((WSPRefs)cour).getRefId());
                            pmCache.put(node, (Object)((WSPRefs)cour).getRefId(), (Object)cour);
                            continue;
                        }
                        if (!(cour instanceof VersionRefs)) continue;
                        node = this.nodePrefix + "/" + PortalCMSCacheLoader.parseNodeName(((VersionRefs)cour).getRefId());
                        pmCache.put(node, (Object)((VersionRefs)cour).getRefId(), (Object)cour);
                    }
                }
                log.info((Object)("Pre-loading the PersistenceManager Cache for" + this.nodePrefix + " (finished)......."));
                tx.commit();
            }
            catch (CacheException ce) {
                if (tx != null) {
                    tx.rollback();
                }
                throw new RuntimeException(ce);
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
                this.done = true;
            }
        }
    }
}

