/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.util.Locale;
import java.util.Vector;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.jboss.portal.cms.impl.ContentImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.util.VersionUtil;

public class ContentGetVersionsCommand
extends JCRCommand {
    private static final long serialVersionUID = 6853173755818339647L;
    String msFilePath;

    public ContentGetVersionsCommand(String sFilePath) {
        this.msFilePath = sFilePath;
    }

    public Object execute() {
        Vector<ContentImpl> contents = new Vector<ContentImpl>();
        try {
            Session session = this.context.getSession();
            Node fileNode = (Node)session.getItem(this.msFilePath);
            VersionHistory vh = fileNode.getVersionHistory();
            Version liveVersion = VersionUtil.getLiveVersion(vh);
            Version rootVersion = vh.getRootVersion();
            VersionIterator vi = vh.getAllVersions();
            while (vi.hasNext()) {
                ContentImpl content = new ContentImpl();
                Version version = vi.nextVersion();
                if (version.equals(rootVersion)) continue;
                NodeIterator ni = version.getNodes();
                while (ni.hasNext()) {
                    Node node = ni.nextNode();
                    content.setTitle(node.getProperty("portalcms:title").getString());
                    content.setDescription(node.getProperty("portalcms:description").getString());
                    content.setLocale(new Locale(node.getProperty("portalcms:language").getString()));
                    content.setVersionPath(node.getPath());
                    content.setBaseUUID(node.getProperty("jcr:frozenUuid").getString());
                    content.setBasePath(session.getNodeByUUID(content.getBaseUUID()).getPath());
                    content.setVersionUUID(node.getUUID());
                    content.setBytes("".getBytes());
                    long size = 0L;
                    if (node.hasProperty("portalcms:size")) {
                        size = Long.parseLong(node.getProperty("portalcms:size").getString());
                    }
                    content.setSize(size);
                    content.setMimeType(node.getProperty("jcr:mimeType").getString());
                    content.setLastModified(node.getProperty("jcr:lastModified").getDate().getTime());
                    content.setName(node.getName());
                    content.setCreationDate(version.getCreated().getTime());
                    content.setVersionNumber(version.getName());
                    if (liveVersion != null && liveVersion.getName().equals(version.getName())) {
                        content.setLive(true);
                    }
                    content.setEncoding(node.getProperty("jcr:encoding").getString());
                    try {
                        String processid = node.getProperty("portalcms:processid").getString();
                        if (processid != null && processid.trim().length() > 0) {
                            content.setWaitingForPublishApproval(true);
                            content.setApprovalProcessId(processid);
                        } else {
                            content.setWaitingForPublishApproval(false);
                            content.setApprovalProcessId(null);
                        }
                    }
                    catch (PathNotFoundException pne) {
                        content.setWaitingForPublishApproval(false);
                        content.setApprovalProcessId(null);
                    }
                    contents.addElement(content);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contents;
    }
}

