/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.ContentImpl;
import org.jboss.portal.cms.impl.FileImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;

public class DownloadArchiveCommand
extends JCRCommand {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DownloadArchiveCommand.class);
    String filePath = null;
    JCRCommandContext mContext;

    public DownloadArchiveCommand(String filePath) {
        this.filePath = filePath;
    }

    public Object execute() {
        File file = null;
        try {
            file = new File(this.filePath);
            FileImpl downloadFile = new FileImpl();
            downloadFile.setName(file.getName());
            ContentImpl downloadFileContent = new ContentImpl();
            downloadFileContent.setSize(file.length());
            downloadFileContent.setStream(new FileInputStream(file));
            downloadFile.setContent(Locale.getDefault(), downloadFileContent);
            FileImpl fileImpl = downloadFile;
            return fileImpl;
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            throw new CMSException(e);
        }
        finally {
            if (file != null && !file.delete()) {
                file.deleteOnExit();
            }
        }
    }
}

