/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Value;
import org.apache.jackrabbit.value.DateValue;
import org.apache.log4j.Logger;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.command.FileBasedJCRCommand;
import org.jboss.portal.cms.impl.jcr.util.ResourceUtil;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.cms.util.NodeUtil;

public class FileCreateCommand
extends FileBasedJCRCommand {
    private static final long serialVersionUID = -653823238247348749L;
    private static Logger log = Logger.getLogger(FileCreateCommand.class);

    public FileCreateCommand(File file) {
        super(file);
    }

    public Object execute() {
        try {
            String basePath = this.mFile.getBasePath();
            JCRCommand existsCMD = (JCRCommand)this.context.getCommandFactory().createItemExistsCommand(basePath);
            Boolean bExists = (Boolean)this.context.execute(existsCMD);
            if (!bExists.booleanValue()) {
                String parentPath = NodeUtil.getParentPath(basePath);
                String nodeName = NodeUtil.getNodeName(basePath);
                ResourceUtil.createParentHierarchy(this.context, parentPath);
                Node parentNode = (Node)this.context.getSession().getItem(parentPath);
                Node fileNode = parentNode.addNode(nodeName, "portalcms:file");
                parentNode.setProperty("jcr:lastModified", (Value)new DateValue(Calendar.getInstance()));
                parentNode.setProperty("portalcms:lastmodified", (Value)new DateValue(Calendar.getInstance()));
                fileNode.setProperty("jcr:lastModified", (Value)new DateValue(Calendar.getInstance()));
                parentNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            throw new CMSException(e);
        }
        return null;
    }
}

