/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.Session;
import org.jboss.portal.cms.impl.FileImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.model.Content;
import org.jboss.portal.cms.util.FileUtil;

public class FileGetCommand
extends JCRCommand {
    private static final long serialVersionUID = 7912459435886700650L;
    String path;
    String versionNumber;
    Locale locale;

    public FileGetCommand(String sPath, Locale locale) {
        this(sPath, null, locale);
    }

    public FileGetCommand(String sPath, String sVersionNumber, Locale locale) {
        this.path = sPath;
        this.versionNumber = sVersionNumber;
        this.locale = locale;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object execute() {
        try {
            FileImpl file = new FileImpl();
            Session session = this.context.getSession();
            boolean exists = session.itemExists(FileUtil.cleanDoubleSlashes(this.path + "/" + this.locale.getLanguage()));
            if (!exists) {
                return null;
            }
            Node fileNode = (Node)session.getItem(this.path);
            fileNode = (Node)session.getItem(this.path);
            file.setCreationDate(fileNode.getProperty("jcr:created").getDate().getTime());
            file.setLastModified(fileNode.getProperty("jcr:lastModified").getDate().getTime());
            file.setBasePath(this.path);
            file.setName(fileNode.getName());
            Content content = null;
            try {
                JCRCommand contentGetCMD = (JCRCommand)this.context.getCommandFactory().createContentGetCommand(this.path, this.versionNumber, this.locale);
                content = (Content)this.context.execute(contentGetCMD);
                file.setContent(this.locale, content);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "FileGetCommand[path=" + this.path + ", versionNumber=" + this.versionNumber + ", locale=" + this.locale + "]";
    }
}

