/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Value;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.StringValue;
import org.jboss.portal.cms.CMSMimeMappings;
import org.jboss.portal.cms.impl.jcr.command.FileBasedJCRCommand;
import org.jboss.portal.cms.impl.jcr.util.VersionUtil;
import org.jboss.portal.cms.model.File;

public class FileUpdateAndVersionCommand
extends FileBasedJCRCommand {
    private static final long serialVersionUID = 882238623005109537L;
    boolean bMakeLive;

    public FileUpdateAndVersionCommand(File file, boolean makeLive) {
        super(file);
        this.bMakeLive = makeLive;
    }

    public Object execute() {
        try {
            Node contentNode = (Node)this.context.getSession().getItem(this.mFile.getContent().getBasePath());
            contentNode.checkout();
            DateValue timestamp = new DateValue(Calendar.getInstance());
            contentNode.setProperty("portalcms:description", this.mFile.getContent().getDescription());
            contentNode.setProperty("portalcms:title", this.mFile.getContent().getTitle());
            contentNode.setProperty("portalcms:language", this.mFile.getContent().getLocale().getLanguage());
            contentNode.setProperty("jcr:encoding", "UTF-8");
            contentNode.setProperty("jcr:data", (Value)new BinaryValue(this.mFile.getContent().getBytes()));
            contentNode.setProperty("jcr:lastModified", (Value)timestamp);
            contentNode.setProperty("portalcms:size", (Value)new StringValue(String.valueOf(this.mFile.getContent().getBytes().length)));
            String basePath = this.mFile.getBasePath();
            if (this.mFile.getContent().getMimeType() != null) {
                contentNode.setProperty("jcr:mimeType", this.mFile.getContent().getMimeType());
            } else {
                CMSMimeMappings mapper = new CMSMimeMappings();
                String fileExt = basePath.substring(basePath.lastIndexOf(".") + 1, basePath.length());
                if (mapper.getMimeType(fileExt) != null) {
                    contentNode.setProperty("jcr:mimeType", mapper.getMimeType(fileExt));
                } else {
                    contentNode.setProperty("jcr:mimeType", "application/octet-stream");
                }
            }
            Node versionNode = (Node)this.context.getSession().getItem(this.mFile.getContent().getBasePath());
            VersionUtil.createVersion(versionNode, this.bMakeLive);
            Node fileNode = (Node)this.context.getSession().getItem(basePath);
            fileNode.setProperty("jcr:lastModified", (Value)timestamp);
            fileNode.getParent().setProperty("portalcms:lastmodified", (Value)timestamp);
            contentNode.getSession().save();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

