/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.util.Calendar;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.Value;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.StringValue;
import org.apache.log4j.Logger;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.jcr.command.FolderBasedJCRCommand;
import org.jboss.portal.cms.impl.jcr.util.ResourceUtil;
import org.jboss.portal.cms.model.Folder;
import org.jboss.portal.cms.util.NodeUtil;

public class FolderCreateCommand
extends FolderBasedJCRCommand {
    private static final long serialVersionUID = -3007711915681479942L;
    private static Logger log = Logger.getLogger(FolderCreateCommand.class);

    public FolderCreateCommand(Folder folder) {
        super(folder);
    }

    public Object execute() {
        try {
            String basePath = this.mFolder.getBasePath();
            String parentPath = NodeUtil.getParentPath(basePath);
            String nodeName = NodeUtil.getNodeName(basePath);
            ResourceUtil.createParentHierarchy(this.context, parentPath);
            Node parentNode = (Node)this.context.getSession().getItem(parentPath);
            Node folderNode = parentNode.addNode(nodeName, "portalcms:folder");
            folderNode.setProperty("portalcms:description", (Value)new StringValue(this.mFolder.getDescription()));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.mFolder.getLastModified());
            DateValue dv = new DateValue(calendar);
            parentNode.setProperty("portalcms:lastmodified", (Value)dv);
            folderNode.setProperty("portalcms:lastmodified", (Value)dv);
            parentNode.save();
        }
        catch (ItemExistsException iee) {
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            throw new CMSException(e);
        }
        return null;
    }
}

