/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.ContentImpl;
import org.jboss.portal.cms.impl.FileImpl;
import org.jboss.portal.cms.impl.FolderImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.util.FileUtil;
import org.jboss.portal.cms.util.NodeUtil;

public class StoreArchiveCommand
extends JCRCommand {
    private static final long serialVersionUID = 1568453649437987499L;
    private static Logger log = Logger.getLogger(StoreArchiveCommand.class);
    String msRootPath;
    byte[] archiveBytes;
    String msLanguage;

    public StoreArchiveCommand(String sRootPath, byte[] archiveBytes, String sLanguage) {
        this.msRootPath = sRootPath;
        this.archiveBytes = archiveBytes;
        this.msLanguage = sLanguage;
    }

    public Object execute() {
        File tmpFile = null;
        try {
            tmpFile = this.getZipFile();
            ZipFile zipFile = new ZipFile(tmpFile);
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)entries.nextElement();
                String itemName = zipEntry.getName();
                if (!NodeUtil.CHECK_FOR_XSS_PATTERN.matcher(itemName).matches()) {
                    log.info((Object)("Zip file: '" + itemName + "' is not a valid file name. It will be skipped."));
                    continue;
                }
                if (!zipEntry.isDirectory()) {
                    this.addFile(zipFile, zipEntry);
                    continue;
                }
                this.addFolder(zipEntry);
            }
            Object var5_6 = null;
            return var5_6;
        }
        catch (Exception e) {
            throw new CMSException(e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    private void addFile(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        try {
            String itemName = zipEntry.getName();
            long fileSize = zipEntry.getSize();
            byte[] zipBytes = new byte[(int)fileSize];
            InputStream zipDataStream = zipFile.getInputStream(zipEntry);
            for (long bytesRead = 0L; bytesRead < fileSize; bytesRead += (long)zipDataStream.read(zipBytes, (int)bytesRead, (int)(fileSize - bytesRead))) {
            }
            FileImpl file = new FileImpl();
            String sBasePath = FileUtil.cleanDoubleSlashes("/" + this.msRootPath + "/" + itemName);
            sBasePath = FileUtil.cleanDoubleSlashes(sBasePath);
            file.setBasePath(sBasePath);
            ContentImpl content = new ContentImpl();
            content.setEncoding("UTF-8");
            content.setTitle(itemName);
            content.setDescription(itemName);
            content.setBasePath(sBasePath + "/" + this.msLanguage);
            content.setBytes(zipBytes);
            file.setContent(new Locale(this.msLanguage), content);
            JCRCommand nodeExists = (JCRCommand)this.context.getCommandFactory().createItemExistsCommand(file.getBasePath());
            Boolean bExists = (Boolean)this.context.execute(nodeExists);
            if (!bExists.booleanValue()) {
                JCRCommand newFile = (JCRCommand)this.context.getCommandFactory().createNewFileCommand(file, content);
                this.context.execute(newFile);
            } else {
                JCRCommand updateFile = (JCRCommand)this.context.getCommandFactory().createUpdateFileCommand(file, content, true);
                this.context.execute(updateFile);
            }
        }
        catch (CMSException e) {
            log.error((Object)this, (Throwable)e);
        }
    }

    private void addFolder(ZipEntry zipEntry) {
        try {
            String itemName = zipEntry.getName();
            if (itemName.endsWith("/")) {
                itemName = itemName.substring(0, itemName.length() - 1);
            }
            if (!"".equals(itemName)) {
                JCRCommand nodeExists2;
                Boolean bExists2;
                String sBasePath = FileUtil.cleanDoubleSlashes("/" + this.msRootPath + "/" + itemName);
                sBasePath = FileUtil.cleanDoubleSlashes(sBasePath);
                String sParentPath = NodeUtil.getParentPath(sBasePath);
                JCRCommand nodeExists = (JCRCommand)this.context.getCommandFactory().createItemExistsCommand(sParentPath);
                Boolean bExists = (Boolean)this.context.execute(nodeExists);
                if (!bExists.booleanValue()) {
                    this.createParentHierarchy(sParentPath);
                }
                if (!(bExists2 = (Boolean)this.context.execute(nodeExists2 = (JCRCommand)this.context.getCommandFactory().createItemExistsCommand(sBasePath))).booleanValue()) {
                    FolderImpl folder = new FolderImpl();
                    folder.setName(itemName);
                    folder.setDescription(itemName);
                    folder.setTitle(itemName);
                    folder.setLastModified(new Date());
                    folder.setBasePath(sBasePath);
                    JCRCommand folderSave = (JCRCommand)this.context.getCommandFactory().createFolderSaveCommand(folder);
                    this.context.execute(folderSave);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
        }
    }

    private void createParentHierarchy(String parentPath) throws CMSException {
        StringTokenizer tokenizer = new StringTokenizer(parentPath, "/");
        StringBuffer buffer = new StringBuffer("/");
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
            String cour = buffer.toString();
            JCRCommand nodeExists = (JCRCommand)this.context.getCommandFactory().createItemExistsCommand(cour);
            Boolean bExists = (Boolean)this.context.execute(nodeExists);
            if (!bExists.booleanValue()) {
                this.createFolder(cour);
            }
            if (!tokenizer.hasMoreTokens()) continue;
            buffer.append("/");
        }
    }

    private void createFolder(String folderPath) throws CMSException {
        FolderImpl folder = new FolderImpl();
        folder.setName(folderPath);
        folder.setDescription(folderPath);
        folder.setTitle(folderPath);
        folder.setLastModified(new Date());
        folder.setBasePath(folderPath);
        JCRCommand parentSave = (JCRCommand)this.context.getCommandFactory().createFolderSaveCommand(folder);
        this.context.execute(parentSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getZipFile() throws Exception {
        File zipFile = null;
        zipFile = File.createTempFile("jbportal_", "_cmsimport.zip");
        FileOutputStream fos = new FileOutputStream(zipFile.getCanonicalPath());
        try {
            fos.write(this.archiveBytes);
            fos.close();
        }
        finally {
            fos.close();
        }
        return zipFile;
    }
}

