/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.ha;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.apache.log4j.Logger;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.Command;
import org.jboss.portal.cms.impl.jcr.JCRCMS;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;
import org.jboss.portal.cms.model.CMSUser;
import org.jboss.portal.identity.User;
import org.jboss.portal.jems.ha.HASingletonInvoker;
import org.jboss.portal.jems.ha.HASingletonInvokerMBean;
import org.jboss.portal.security.impl.jacc.JACCPortalPrincipal;

public class HAJCRCMS
extends JCRCMS
implements HASingletonInvokerMBean.Callback {
    private static Logger log = Logger.getLogger(HAJCRCMS.class);
    private HASingletonInvoker invoker;

    public Object execute(Command cmd) throws CMSException {
        JCRCommandContext context;
        if (this.invoker == null || this.invoker.isMasterNode()) {
            return super.execute(cmd);
        }
        if (this.getUserInfo().get() != null) {
            User user = (User)this.getUserInfo().get();
            context = this.getCommandContext((JCRCommand)cmd);
            context.setClusterContextInfo("user", new CMSUser(user.getUserName()));
            try {
                Set roles = this.getCurrentRoles();
                context.setClusterContextInfo("roles", roles);
            }
            catch (PolicyContextException e) {
                throw new CMSException(e);
            }
        }
        if (turnOffWorkflow.get() != null) {
            Boolean workflowStatus = (Boolean)turnOffWorkflow.get();
            context = this.getCommandContext((JCRCommand)cmd);
            context.setClusterContextInfo("workflowStatus", workflowStatus);
        }
        if (this.isUISecurityFilterActive()) {
            JCRCommandContext context2 = this.getCommandContext((JCRCommand)cmd);
            context2.setClusterContextInfo("enableUISecurityFilter", Boolean.TRUE);
        }
        Object returnValue = null;
        try {
            returnValue = this.invoker.invoke("execute", new Class[]{Command.class}, new Object[]{cmd});
            if (returnValue instanceof CMSException) {
                CMSException cmsException = (CMSException)returnValue;
                if (cmsException.toString().indexOf("Access to this resource is denied") != -1 || cmsException.hasPathFormatFailure() || cmsException.isServiceUnavailable()) {
                    throw cmsException;
                }
                returnValue = null;
            }
        }
        catch (Exception e) {
            if (e instanceof CMSException) {
                throw (CMSException)e;
            }
            throw new CMSException(e);
        }
        return returnValue;
    }

    public void startService() throws Exception {
    }

    public void stopService() {
    }

    public void setInvoker(HASingletonInvoker invoker) {
        this.invoker = invoker;
    }

    public Object invoke(String methodName, Class[] types, Object[] args) throws CMSException {
        Object result;
        block2: {
            result = null;
            try {
                Command cmd = (Command)((Object)args[0]);
                result = super.execute(cmd);
            }
            catch (CMSException ce) {
                if (ce.toString().indexOf("Access to this resource is denied") == -1 && !ce.hasPathFormatFailure()) break block2;
                result = ce;
            }
        }
        return result;
    }

    public String getDisplayName() {
        return "HAJCRCMS";
    }

    public void startSingleton() {
        try {
            super.startService();
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
        }
    }

    public void stopSingleton() {
        super.stopService();
    }

    private JCRCommandContext getCommandContext(JCRCommand command) {
        JCRCommandContext context = null;
        context = (JCRCommandContext)command.getContext();
        if (context == null) {
            context = new JCRCommandContext(null, null, null);
            command.setContext(context);
        }
        return context;
    }

    private Set getCurrentRoles() throws PolicyContextException {
        HashSet<String> roles = new HashSet<String>();
        Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        if (subject != null) {
            Set<JACCPortalPrincipal> tmp = subject.getPrincipals(JACCPortalPrincipal.class);
            JACCPortalPrincipal pp2 = null;
            for (JACCPortalPrincipal pp2 : tmp) {
                if (pp2 != null) break;
            }
            if (pp2 == null) {
                pp2 = new JACCPortalPrincipal(subject);
                tmp.add(pp2);
                for (Principal role : pp2.getRoles()) {
                    roles.add(role.getName());
                }
            }
        }
        return roles;
    }
}

