/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.util;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.jcr.util.NodeTypeUtil;

public class VersionUtil {
    public static void createVersion(Node node, boolean isLive) throws CMSException {
        if (NodeTypeUtil.isFolder(node)) {
            VersionUtil.createFolderVersion(node, isLive);
        } else if (NodeTypeUtil.isFile(node)) {
            VersionUtil.createFileVersion(node, isLive);
        } else if (NodeTypeUtil.isContent(node)) {
            VersionUtil.createContentVersion(node, isLive);
        }
    }

    public static void createContentVersion(Node node, boolean isLive) throws CMSException {
        if (!NodeTypeUtil.isContent(node)) {
            throw new CMSException("The node is not a \"content\"");
        }
        try {
            if (isLive) {
                VersionHistory versionHistory = node.getVersionHistory();
                versionHistory.addVersionLabel(node.checkin().getName(), "LIVE", true);
            } else {
                node.checkin();
            }
        }
        catch (RepositoryException e) {
            throw new CMSException("Cannot mark the content as \"Live\"");
        }
    }

    public static void createFileVersion(Node node, boolean isLive) throws CMSException {
        if (!NodeTypeUtil.isFile(node)) {
            throw new CMSException("The node is not a \"file\"");
        }
        try {
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                Node tmpNode = (Node)it.next();
                if (!NodeTypeUtil.isContent(tmpNode)) continue;
                VersionUtil.createContentVersion(tmpNode, isLive);
            }
        }
        catch (RepositoryException e) {
            throw new CMSException("Cannot mark the file as \"Live\"");
        }
    }

    public static void createFolderVersion(Node node, boolean isLive) throws CMSException {
        if (!NodeTypeUtil.isFolder(node)) {
            throw new CMSException("The node is not a \"folder\"");
        }
        try {
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                Node tmpNode = (Node)it.next();
                if (NodeTypeUtil.isFolder(tmpNode)) {
                    VersionUtil.createFolderVersion(tmpNode, isLive);
                    continue;
                }
                VersionUtil.createFileVersion(tmpNode, isLive);
            }
        }
        catch (RepositoryException e) {
            throw new CMSException("Cannot mark the directory as \"Live\"");
        }
    }

    public static void print(Node node) {
        try {
            VersionHistory vh = node.getVersionHistory();
            VersionIterator vi = vh.getAllVersions();
            while (vi.hasNext()) {
                Version v = vi.nextVersion();
                NodeIterator ni = v.getNodes();
                while (ni.hasNext()) {
                    Node n = ni.nextNode();
                    System.out.println("################### VERSION: " + v.getName() + " ###################");
                    System.out.println("Version Path: " + v.getPath());
                    System.out.println("Node Path: " + n.getPath());
                    PropertyIterator references = v.getReferences();
                    while (references.hasNext()) {
                        Property ref = references.nextProperty();
                        System.out.println("REF: " + ref.getName());
                    }
                    PropertyIterator pi2 = n.getProperties();
                    while (pi2.hasNext()) {
                        Property p2 = pi2.nextProperty();
                        if (p2.getName().equals("jcr:frozenMixinTypes") || p2.getName().equals("jcr:predecessors")) continue;
                        System.out.println(p2.getName() + " = " + p2.getString());
                    }
                    NodeIterator ni2 = n.getNodes();
                    while (ni2.hasNext()) {
                        Node n2 = ni2.nextNode();
                        System.out.println("$$$$$$$$$$ " + n2.getName() + "$$$$$$$$$$");
                        System.out.println("$$$$$$$$$$" + n2.getPath() + "$$$$$$$$$$");
                        PropertyIterator references2 = n2.getReferences();
                        while (references2.hasNext()) {
                            Property ref2 = references2.nextProperty();
                            System.out.println("REF: " + ref2.getName());
                        }
                        PropertyIterator pi3 = n2.getProperties();
                        while (pi3.hasNext()) {
                            Property p3 = pi3.nextProperty();
                            System.out.println(p3.getName() + " = " + p3.getString());
                        }
                    }
                }
                System.out.println("\n\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Version getLiveVersion(VersionHistory history) {
        Version liveVersion = null;
        try {
            liveVersion = history.getVersionByLabel("LIVE");
        }
        catch (Exception e) {
            liveVersion = null;
        }
        return liveVersion;
    }
}

