/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.security;

import javax.security.auth.Subject;
import org.jboss.portal.cms.impl.jcr.command.ACLEnforcer;
import org.jboss.portal.cms.security.AuthorizationManager;
import org.jboss.portal.cms.security.AuthorizationProvider;
import org.jboss.portal.cms.security.CMSPermission;
import org.jboss.portal.jems.as.JNDI;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;

public class AuthorizationManagerImpl
extends AbstractJBossService
implements AuthorizationManager {
    private ACLEnforcer enforcer = null;
    private AuthorizationProvider provider = null;
    private String jndiName = null;
    private JNDI.Binding jndiBinding = null;

    public AuthorizationProvider getProvider() {
        return this.provider;
    }

    public void setProvider(AuthorizationProvider provider) {
        this.provider = provider;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void startService() throws Exception {
        super.startService();
        if (this.jndiName != null) {
            this.jndiBinding = new JNDI.Binding(this.jndiName, (Object)this);
            this.jndiBinding.bind();
        }
        this.setEnforcer(new ACLEnforcer(this));
    }

    public PortalAuthorizationManager getManager() throws PortalSecurityException {
        return this;
    }

    public boolean checkPermission(PortalPermission permission) throws PortalSecurityException {
        return this.enforcer.hasAccess(((CMSPermission)permission).getSecurityContext());
    }

    public boolean checkPermission(Subject checkedSubject, PortalPermission permission) throws PortalSecurityException {
        return this.checkPermission(permission);
    }

    protected void setEnforcer(ACLEnforcer enforcer) {
        this.enforcer = enforcer;
    }
}

