/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.security;

import java.security.BasicPermission;
import java.util.HashSet;
import java.util.Set;
import org.jboss.portal.cms.security.Criteria;
import org.jboss.portal.cms.security.PermRoleAssoc;
import org.jboss.portal.cms.security.PermUserAssoc;

public class Permission
extends BasicPermission {
    private long id = 0L;
    private String service = null;
    private String action = null;
    private boolean isNegated = false;
    private Set criteria = null;
    private Set roleAssoc = null;
    private Set userAssoc = null;
    private Set roles = null;
    private Set users = null;

    public Permission() {
        this("null");
    }

    public Permission(String service) {
        super(service);
        this.service = service;
    }

    public Permission(String service, String actions) {
        super(service, actions);
        this.service = service;
        this.action = actions;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Set getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Set criteria) {
        this.criteria = criteria;
    }

    public void addCriteria(Criteria criteria) {
        if (this.criteria == null) {
            this.criteria = new HashSet();
        }
        this.criteria.add(criteria);
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String findCriteriaValue(String criteriaId) {
        String value = null;
        if (this.criteria != null) {
            for (Criteria cour : this.criteria) {
                if (!criteriaId.equals(cour.getName())) continue;
                value = cour.getValue();
            }
        }
        return value;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public void setNegated(boolean isNegated) {
        this.isNegated = isNegated;
    }

    public Set getRoleAssoc() {
        return this.roleAssoc;
    }

    public void setRoleAssoc(Set roleAssoc) {
        this.roleAssoc = roleAssoc;
    }

    public void addRoleAssoc(PermRoleAssoc roleAssoc) {
        if (this.roleAssoc == null) {
            this.roleAssoc = new HashSet();
        }
        this.roleAssoc.add(roleAssoc);
    }

    public Set getRoleAssocIds() {
        HashSet<String> ids = new HashSet<String>();
        if (this.roleAssoc != null) {
            for (PermRoleAssoc cour : this.roleAssoc) {
                ids.add(cour.getRoleId());
            }
        }
        return ids;
    }

    public Set getUserAssoc() {
        return this.userAssoc;
    }

    public void setUserAssoc(Set userAssoc) {
        this.userAssoc = userAssoc;
    }

    public void addUserAssoc(PermUserAssoc userAssoc) {
        if (this.userAssoc == null) {
            this.userAssoc = new HashSet();
        }
        this.userAssoc.add(userAssoc);
    }

    public Set getUserAssocIds() {
        HashSet<String> ids = new HashSet<String>();
        if (this.userAssoc != null) {
            for (PermUserAssoc cour : this.userAssoc) {
                ids.add(cour.getUserId());
            }
        }
        return ids;
    }

    public Set getRoles() {
        return this.roles;
    }

    public void setRoles(Set roles) {
        this.roles = roles;
    }

    public Set getUsers() {
        return this.users;
    }

    public void setUsers(Set users) {
        this.users = users;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("-----------------------------\n");
        buffer.append("ID=" + this.id + "\n");
        buffer.append("Service=" + this.service + "\n");
        buffer.append("Action=" + this.action + "\n");
        buffer.append("Negated=" + this.isNegated + "\n");
        if (this.roleAssoc != null) {
            for (Object cour : this.roleAssoc) {
                buffer.append("Role =" + ((PermRoleAssoc)cour).getRoleId() + "\n");
            }
        }
        if (this.userAssoc != null) {
            for (Object cour : this.userAssoc) {
                buffer.append("User =" + ((PermUserAssoc)cour).getUserId() + "\n");
            }
        }
        if (this.criteria != null) {
            for (Object cour : this.criteria) {
                buffer.append("Criteria =" + ((Criteria)cour).getName() + "," + ((Criteria)cour).getValue() + "\n");
            }
        }
        buffer.append("-----------------------------\n");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof Permission) {
            Permission input = (Permission)obj;
            if (input.id == this.id) {
                equals = true;
            }
        }
        return equals;
    }
}

