/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.util;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernateUtil {
    public static SessionFactory getSessionFactory(String jndiName) {
        if (jndiName == null) {
            throw new IllegalStateException("You need to specify a JNDI Name for the HibernateSessionFactory");
        }
        try {
            InitialContext ic = new InitialContext();
            return (SessionFactory)ic.lookup(jndiName);
        }
        catch (NamingException e) {
            throw new IllegalStateException("No HibernateSessionFactory can be found in the JNDI tree at: " + jndiName);
        }
    }

    public static void closeSession(Session session) {
        if (session != null && session.isOpen()) {
            session.close();
        }
    }
}

