/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.workflow;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.portal.cms.CMS;
import org.jboss.portal.cms.Command;
import org.jboss.portal.cms.impl.interceptors.ACLInterceptor;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.cms.workflow.Content;
import org.jbpm.bytes.ByteArray;

public class CMSWorkflowUtil {
    public static org.jboss.portal.cms.model.Content getPendingContent(long processId, String contentPath) {
        org.jboss.portal.cms.model.Content content = null;
        int lastIndex = contentPath.lastIndexOf(47);
        String path = contentPath.substring(0, lastIndex);
        String language = contentPath.substring(lastIndex + 1);
        ACLInterceptor.turnOff();
        CMS cms = CMSWorkflowUtil.getCMSService();
        Command command = cms.getCommandFactory().createContentGetVersionsCommand(contentPath);
        List versions = (List)cms.execute(command);
        content = CMSWorkflowUtil.findProcessContent(processId, versions);
        if (content != null) {
            command = cms.getCommandFactory().createFileGetCommand(path, content.getVersionNumber(), new Locale(language));
            File file = (File)cms.execute(command);
            content = file.getContent();
        }
        ACLInterceptor.turnOn();
        return content;
    }

    private static org.jboss.portal.cms.model.Content findProcessContent(long processId, List versions) {
        org.jboss.portal.cms.model.Content content = null;
        if (versions != null) {
            for (int i = 0; i < versions.size(); ++i) {
                org.jboss.portal.cms.model.Content cour = (org.jboss.portal.cms.model.Content)versions.get(i);
                if (!cour.isWaitingForPublishApproval() || cour.getApprovalProcessId() == null || !cour.getApprovalProcessId().trim().equals(String.valueOf(processId))) continue;
                return cour;
            }
        }
        return content;
    }

    public static CMS getCMSService() {
        CMS cms = null;
        try {
            MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
            cms = (CMS)MBeanProxy.get(CMS.class, (ObjectName)new ObjectName("portal:service=CMS"), (MBeanServer)mbeanServer);
        }
        catch (Exception e) {
            try {
                cms = (CMS)new InitialContext().lookup("java:/portal/CMS");
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return cms;
    }

    public static Content deserializeContent(Object object) throws Exception {
        Content content = null;
        if (object instanceof ByteArray) {
            byte[] objectBytes = ((ByteArray)object).getBytes();
            content = (Content)new ObjectInputStream(new ByteArrayInputStream(objectBytes)).readObject();
        } else if (object instanceof Content) {
            content = (Content)object;
        }
        return content;
    }
}

