/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.CachedUserImpl;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.db.HibernateUserImpl;
import org.jboss.portal.identity.info.ProfileInfo;
import org.jboss.portal.identity.info.PropertyInfo;
import org.jboss.portal.identity.ldap.LDAPUserImpl;
import org.jboss.portal.identity.service.UserProfileModuleService;

public class DelegatingUserProfileModuleImpl
extends UserProfileModuleService {
    private static final Logger log = Logger.getLogger(DelegatingUserProfileModuleImpl.class);
    private String ldapModuleJNDIName;
    private String dbModuleJNDIName;
    private UserProfileModule LDAPModule;
    private UserProfileModule dbModule;

    public void start() throws Exception {
        super.start();
        if (this.getProfileInfo() == null) {
            throw new IdentityException("No profile information found. Check the configuration.");
        }
        if (this.getJNDIName().equals(this.getDbModuleJNDIName())) {
            throw new IdentityException("Cannot delegate to itself - correct dbModuleJNDIName option");
        }
        if (this.getJNDIName().equals(this.getLdapModuleJNDIName())) {
            throw new IdentityException("Cannot delegate to itself - correct ldapModuleJNDIName option");
        }
    }

    public Object getProperty(User user, String propertyName) throws IdentityException, IllegalArgumentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getProperty: " + propertyName));
        }
        try {
            PropertyInfo property = this.getProfileInfo().getPropertyInfo(propertyName);
            if (property == null) {
                throw new IdentityException("Such property name is not supported: " + propertyName);
            }
            if (user instanceof CachedUserImpl) {
                user = this.obtainUser(user);
            }
            if (property.isMappedLDAP() && this.isLDAPSupported() && user instanceof LDAPUserImpl) {
                log.debug((Object)"Delegating to LDAP module");
                return this.getLDAPModule().getProperty(user, propertyName);
            }
            if (property.isMappedDB()) {
                log.debug((Object)"Delegating to DB module");
                return this.getDBModule().getProperty(user, propertyName);
            }
            throw new IdentityException("Cannot process property - incorrect profile or module configuration");
        }
        catch (Exception e) {
            throw new IdentityException("Cannot resolve property: " + propertyName, e);
        }
    }

    public void setProperty(User user, String name, Object propertyValue) throws IdentityException, IllegalArgumentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setProperty: " + name + "/" + propertyValue));
        }
        try {
            PropertyInfo property = this.getProfileInfo().getPropertyInfo(name);
            if (property == null) {
                throw new IdentityException("Such property name is not supported: " + name);
            }
            if (user instanceof CachedUserImpl) {
                user = this.obtainUser(user);
            }
            if (property.isMappedLDAP() && this.isLDAPSupported() && user instanceof LDAPUserImpl) {
                log.debug((Object)"Delegating to LDAP module");
                this.getLDAPModule().setProperty(user, name, propertyValue);
                return;
            }
            if (property.isMappedDB()) {
                log.debug((Object)"Delegating to DB module");
                this.getDBModule().setProperty(user, name, propertyValue);
                this.fireUserProfileChangedEvent(user.getId(), user.getUserName(), name, propertyValue);
                return;
            }
            throw new IdentityException("Cannot process property - incorrect profile or module configuration");
        }
        catch (Exception e) {
            throw new IdentityException("Cannot resolve property: " + name, e);
        }
    }

    public Map getProperties(User user) throws IdentityException, IllegalArgumentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getProperties");
        }
        try {
            if (user instanceof CachedUserImpl) {
                user = this.obtainUser(user);
            }
            if (user instanceof LDAPUserImpl && this.isLDAPSupported()) {
                log.debug((Object)"handling LDAP user implementation");
                HashMap props = new HashMap();
                UserProfileModule dbModule = null;
                UserProfileModule ldapModule = null;
                try {
                    dbModule = this.getDBModule();
                    props.putAll(dbModule.getProperties(user));
                }
                catch (Exception e) {
                    // empty catch block
                }
                ldapModule = this.getLDAPModule();
                props.putAll(ldapModule.getProperties(user));
                return Collections.unmodifiableMap(props);
            }
            if (user instanceof HibernateUserImpl && this.isDBSupported()) {
                log.debug((Object)"Delegating to DB module");
                return this.getDBModule().getProperties(user);
            }
            throw new IdentityException("Cannot process properties - incorrect profile or module configuration");
        }
        catch (Exception e) {
            throw new IdentityException("Cannot resolve properties: ", e);
        }
    }

    private User obtainUser(User user) throws IdentityException {
        UserModule um = (UserModule)this.getIdentityContext().getObject("User");
        return um.findUserById(user.getId());
    }

    public ProfileInfo getProfileInfo() throws IdentityException {
        return this.profileInfo;
    }

    public String getLdapModuleJNDIName() {
        return this.ldapModuleJNDIName;
    }

    public void setLdapModuleJNDIName(String ldapModuleJNDIName) {
        this.ldapModuleJNDIName = ldapModuleJNDIName;
    }

    public String getDbModuleJNDIName() {
        return this.dbModuleJNDIName;
    }

    public void setDbModuleJNDIName(String dbModuleJNDIName) {
        this.dbModuleJNDIName = dbModuleJNDIName;
    }

    public boolean isLDAPSupported() {
        return this.getLdapModuleJNDIName() != null;
    }

    public boolean isDBSupported() {
        return this.getDbModuleJNDIName() != null;
    }

    protected UserProfileModule getDBModule() throws Exception {
        if (this.dbModule == null) {
            this.dbModule = (UserProfileModule)new InitialContext().lookup(this.getDbModuleJNDIName());
            if (this.dbModule == null) {
                throw new IdentityException("Couldn't obtain DB UserProfileModule");
            }
        }
        return this.dbModule;
    }

    protected UserProfileModule getLDAPModule() throws Exception {
        if (this.LDAPModule == null) {
            this.LDAPModule = (UserProfileModule)new InitialContext().lookup(this.getLdapModuleJNDIName());
            if (this.LDAPModule == null) {
                throw new IdentityException("Couldn't obtain LDAP UserProfileModule");
            }
        }
        return this.LDAPModule;
    }

    public void setLDAPModule(UserProfileModule LDAPModule) {
        this.LDAPModule = LDAPModule;
    }

    public void setDbModule(UserProfileModule dbModule) {
        this.dbModule = dbModule;
    }
}

