/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.boot;

import java.util.List;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.portal.identity.IdentityContext;
import org.jboss.portal.identity.ServiceJNDIBinder;
import org.jboss.portal.identity.metadata.config.DatasourceMetaData;
import org.jboss.portal.identity.metadata.config.ModuleMetaData;
import org.jboss.portal.identity.metadata.service.DatasourceServiceMetaData;
import org.jboss.portal.identity.metadata.service.ModuleServiceMetaData;

public class IdentityServiceLoader {
    private final IdentityContext identityContext;
    private final Kernel kernel;
    private final boolean registerMBeans;

    public IdentityServiceLoader(IdentityContext identityContext, Kernel kernel, boolean registerMBeans) {
        this.identityContext = identityContext;
        this.kernel = kernel;
        this.registerMBeans = registerMBeans;
    }

    public void bootstrapDatasource(List datasources) throws Throwable {
        for (DatasourceServiceMetaData datasourceService : datasources) {
            DatasourceMetaData ds = datasourceService.getDatasource();
            String entryName = "portal:identity=Datasource,type=" + ds.getName();
            AbstractBeanMetaData dsBMD = new AbstractBeanMetaData(entryName, ds.getClassName());
            AbstractPropertyMetaData propertyBMD = new AbstractPropertyMetaData("identityContext", (Object)this.identityContext);
            dsBMD.addProperty((PropertyMetaData)propertyBMD);
            propertyBMD = new AbstractPropertyMetaData("jndiBinder", (Object)this.getServiceJNDIBinder());
            dsBMD.addProperty((PropertyMetaData)propertyBMD);
            for (String propertyKey : datasourceService.getOptions().keySet()) {
                String propertyValue = (String)datasourceService.getOptions().get(propertyKey);
                propertyBMD = new AbstractPropertyMetaData(propertyKey, propertyValue);
                dsBMD.addProperty((PropertyMetaData)propertyBMD);
            }
            KernelControllerContext controllerContext = this.kernel.getController().install((BeanMetaData)dsBMD);
            Object datasource = controllerContext.getTarget();
            if (!this.isRegisterMBeans() || ds.getServiceName() == null) continue;
            this.unregisterMBean(ds.getServiceName());
            this.registerMBean(ds.getServiceName(), datasource);
        }
    }

    public void bootstrapModules(List modules) throws Throwable {
        for (ModuleServiceMetaData moduleService : modules) {
            ModuleMetaData module = moduleService.getModuleData();
            String entryName = "portal:identity=Module,type=" + module.getType();
            AbstractBeanMetaData moduleBMD = new AbstractBeanMetaData(entryName, module.getClassName());
            AbstractPropertyMetaData propertyBMD = new AbstractPropertyMetaData("identityContext", (Object)this.identityContext);
            moduleBMD.addProperty((PropertyMetaData)propertyBMD);
            propertyBMD = new AbstractPropertyMetaData("jndiBinder", (Object)this.getServiceJNDIBinder());
            moduleBMD.addProperty((PropertyMetaData)propertyBMD);
            for (String propertyKey : moduleService.getModuleOptions().keySet()) {
                String propertyValue = (String)moduleService.getModuleOptions().get(propertyKey);
                propertyBMD = new AbstractPropertyMetaData(propertyKey, propertyValue);
                moduleBMD.addProperty((PropertyMetaData)propertyBMD);
            }
            propertyBMD = new AbstractPropertyMetaData("moduleType", module.getType());
            moduleBMD.addProperty((PropertyMetaData)propertyBMD);
            KernelControllerContext controllerContext = this.kernel.getController().install((BeanMetaData)moduleBMD);
            Object moduleServiceObject = controllerContext.getTarget();
            if (!this.isRegisterMBeans() || module.getServiceName() == null) continue;
            this.unregisterMBean(module.getServiceName());
            this.registerMBean(module.getServiceName(), moduleServiceObject);
        }
    }

    protected void unregisterMBean(String serviceName) throws Exception {
    }

    protected void registerMBean(String serviceName, Object serviceObject) throws Exception {
    }

    protected ServiceJNDIBinder getServiceJNDIBinder() throws Exception {
        return null;
    }

    public IdentityContext getIdentityContext() {
        return this.identityContext;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public boolean isRegisterMBeans() {
        return this.registerMBeans;
    }
}

