/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.db;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.portal.identity.IdentityServiceController;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.event.IdentityEventBroadcaster;
import org.jboss.portal.identity.event.RoleUpdatedEvent;

public class HibernateRoleImpl
implements Role {
    private static final Logger log = Logger.getLogger(HibernateRoleImpl.class);
    private Long key = null;
    private String name;
    private Set users;
    private String displayName;
    private IdentityEventBroadcaster eventBroadcaster;

    public HibernateRoleImpl() {
        this.name = null;
        this.displayName = null;
        this.users = new HashSet();
    }

    public HibernateRoleImpl(String name) {
        this.name = name;
        this.displayName = name;
        this.users = new HashSet();
    }

    public HibernateRoleImpl(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
        this.users = new HashSet();
    }

    protected Long getKey() {
        return this.key;
    }

    protected void setKey(Long key) {
        this.key = key;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setUsers(Set users) {
        this.users = users;
    }

    public Object getId() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        IdentityEventBroadcaster broadcaster = this.getEventBroadcaster();
        if (broadcaster != null && this.getId() != null && this.getName() != null && this.getDisplayName() != null) {
            RoleUpdatedEvent event = new RoleUpdatedEvent(this.getId(), this.getName(), displayName);
            broadcaster.fireEvent(event);
        }
    }

    public Set getUsers() {
        return this.users;
    }

    public String toString() {
        return "Role[" + this.key + "," + this.name + "]";
    }

    private IdentityEventBroadcaster getEventBroadcaster() {
        if (this.eventBroadcaster == null) {
            try {
                MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
                IdentityServiceController identityService = (IdentityServiceController)MBeanProxy.get(IdentityServiceController.class, (ObjectName)new ObjectName("portal:service=Module,type=IdentityServiceController"), (MBeanServer)mbeanServer);
                this.eventBroadcaster = (IdentityEventBroadcaster)identityService.getIdentityContext().getObject("IdentityEventBroadcaster");
            }
            catch (Exception e) {
                log.error((Object)"Failed to obtain IdentityEventBroadcaster. RoleUpdatedEvent won't be broadcasted");
            }
        }
        return this.eventBroadcaster;
    }
}

