/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.db;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.db.HibernateRoleImpl;
import org.jboss.portal.identity.db.HibernateUserImpl;
import org.jboss.portal.identity.service.RoleModuleService;

public class HibernateRoleModuleImpl
extends RoleModuleService {
    private static final Logger log = Logger.getLogger(HibernateRoleModuleImpl.class);
    protected SessionFactory sessionFactory;
    protected String sessionFactoryJNDIName;

    public void start() throws Exception {
        this.sessionFactory = (SessionFactory)new InitialContext().lookup(this.sessionFactoryJNDIName);
        super.start();
    }

    public void stop() throws Exception {
        this.sessionFactory = null;
        super.stop();
    }

    public String getSessionFactoryJNDIName() {
        return this.sessionFactoryJNDIName;
    }

    public void setSessionFactoryJNDIName(String sessionFactoryJNDIName) {
        this.sessionFactoryJNDIName = sessionFactoryJNDIName;
    }

    public Role findRoleByName(String name) throws IdentityException {
        if (name != null) {
            try {
                Session session = this.getCurrentSession();
                Criteria criteria = session.createCriteria(HibernateRoleImpl.class);
                criteria.add((Criterion)Restrictions.naturalId().set("name", (Object)name));
                criteria.setCacheable(true);
                HibernateRoleImpl role = (HibernateRoleImpl)criteria.uniqueResult();
                if (role == null) {
                    throw new IdentityException("No such role " + name);
                }
                return role;
            }
            catch (HibernateException e) {
                String message = "Cannot find role by name " + name;
                log.error((Object)message, (Throwable)e);
                throw new IdentityException(message, e);
            }
        }
        throw new IllegalArgumentException("name cannot be null");
    }

    public Set findRolesByNames(String[] names) throws IdentityException {
        if (names != null) {
            try {
                Session session = this.getCurrentSession();
                StringBuffer queryString = new StringBuffer("from HibernateRoleImpl as g where g.name=?");
                for (int i = 1; i < names.length; ++i) {
                    queryString.append(" or g.name=?");
                }
                Query query = session.createQuery(queryString.toString());
                for (int i = 0; i < names.length; ++i) {
                    query.setString(i, names[i]);
                }
                Iterator iterator = query.iterate();
                return Tools.toSet((Iterator)iterator);
            }
            catch (HibernateException e) {
                String message = "Cannot find roles";
                log.error((Object)message, (Throwable)e);
                throw new IdentityException(message, e);
            }
        }
        throw new IllegalArgumentException("name cannot be null");
    }

    public Role findRoleById(String id) throws IllegalArgumentException, IdentityException {
        if (id == null) {
            throw new IllegalArgumentException("The id is null");
        }
        try {
            return this.findRoleById(new Long(id));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse id into an long " + id);
        }
    }

    public Role findRoleById(Object id) throws IdentityException {
        if (id instanceof Long) {
            try {
                Session session = this.getCurrentSession();
                HibernateRoleImpl role = (HibernateRoleImpl)session.get(HibernateRoleImpl.class, (Serializable)((Long)id));
                if (role == null) {
                    throw new IdentityException("No role found for " + id);
                }
                return role;
            }
            catch (HibernateException e) {
                String message = "Cannot find role by id " + id;
                log.error((Object)message, (Throwable)e);
                throw new IdentityException(message, e);
            }
        }
        throw new IllegalArgumentException("The id is not an long : " + id);
    }

    public Role createRole(String name, String displayName) throws IdentityException {
        if (name != null) {
            try {
                HibernateRoleImpl role = new HibernateRoleImpl(name, displayName);
                Session session = this.getCurrentSession();
                session.save((Object)role);
                this.fireRoleCreatedEvent(role.getId(), role.getName());
                return role;
            }
            catch (HibernateException e) {
                String message = "Cannot create role " + name;
                log.error((Object)message, (Throwable)e);
                throw new IdentityException(message, e);
            }
        }
        throw new IllegalArgumentException("name cannot be null");
    }

    public void removeRole(Object id) throws IdentityException {
        if (id instanceof Long) {
            try {
                Session session = this.getCurrentSession();
                HibernateRoleImpl role = (HibernateRoleImpl)session.load(HibernateRoleImpl.class, (Serializable)((Long)id));
                for (HibernateUserImpl user : role.getUsers()) {
                    user.getRoles().remove(role);
                }
                String name = role.getName();
                session.delete((Object)role);
                session.flush();
                this.fireRoleDestroyedEvent(id, name);
            }
            catch (HibernateException e) {
                String message = "Cannot remove role  " + id;
                log.error((Object)message, (Throwable)e);
                throw new IdentityException(message, e);
            }
        } else {
            throw new IllegalArgumentException("The id is not an long : " + id);
        }
    }

    public int getRolesCount() throws IdentityException {
        try {
            Session session = this.getCurrentSession();
            Query query = session.createQuery("select count(g.id) from HibernateRoleImpl as g");
            return ((Number)query.uniqueResult()).intValue();
        }
        catch (HibernateException e) {
            String message = "Cannot count roles";
            log.error((Object)message, (Throwable)e);
            throw new IdentityException(message, e);
        }
    }

    public Set findRoles() throws IdentityException {
        try {
            Session session = this.getCurrentSession();
            Query query = session.createQuery("from HibernateRoleImpl as r order by r.name");
            Iterator iterator = query.iterate();
            return Tools.toSet((Iterator)iterator, (boolean)true);
        }
        catch (HibernateException e) {
            String message = "Cannot find roles";
            log.error((Object)message, (Throwable)e);
            throw new IdentityException(message, e);
        }
    }

    public Set findRoleMembers(String roleName, int offset, int limit, String userNameFilter) throws IdentityException {
        if (roleName != null) {
            try {
                Query query;
                Session session = this.getCurrentSession();
                if (userNameFilter.trim().length() != 0) {
                    userNameFilter = "%" + userNameFilter.replaceAll("%", "") + "%";
                    query = session.createQuery("from HibernateUserImpl as user left join user.roles role where role.name=:name AND user.userName LIKE :filter order by user.userName");
                    query.setString("filter", userNameFilter);
                } else {
                    query = session.createQuery("from HibernateUserImpl as user left join user.roles role where role.name=:name order by user.userName");
                }
                query.setString("name", roleName);
                query.setFirstResult(offset);
                query.setMaxResults(limit);
                Iterator iterator = query.iterate();
                Set result = Tools.toSet((Iterator)iterator, (boolean)true);
                HashSet<Object> newResult = new HashSet<Object>();
                for (Object[] oArr : result) {
                    newResult.add(oArr[0]);
                }
                return newResult;
            }
            catch (HibernateException e) {
                String message = "Cannot find role  " + roleName;
                log.error((Object)message, (Throwable)e);
                throw new IdentityException(message, e);
            }
        }
        throw new IllegalArgumentException("id cannot be null");
    }

    public void setRoles(User user, Set roles) throws IdentityException {
        if (!(user instanceof HibernateUserImpl)) {
            throw new IllegalArgumentException("User is not a db user");
        }
        HashSet copy = new HashSet();
        for (Object o : roles) {
            if (o instanceof HibernateRoleImpl) {
                copy.add(o);
                continue;
            }
            throw new IllegalArgumentException("Only db roles can be accepted");
        }
        HibernateUserImpl ui = (HibernateUserImpl)user;
        ui.setRoles(copy);
    }

    public Set getRoles(User user) throws IdentityException {
        if (!(user instanceof HibernateUserImpl)) {
            throw new IllegalArgumentException("User is not a db user");
        }
        HibernateUserImpl ui = (HibernateUserImpl)user;
        return Collections.unmodifiableSet(ui.getRoles());
    }

    protected Session getCurrentSession() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("No session factory");
        }
        return this.sessionFactory.getCurrentSession();
    }
}

