/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.ldap.LDAPRoleImpl;
import org.jboss.portal.identity.ldap.LDAPRoleModuleImpl;

public class LDAPExtRoleModuleImpl
extends LDAPRoleModuleImpl {
    private static final Logger log = Logger.getLogger(LDAPExtRoleModuleImpl.class);

    public Role findRoleByName(String name) throws IdentityException, IllegalArgumentException {
        try {
            log.debug((Object)("findRoleByName(): name = " + name));
            if (name == null) {
                throw new IdentityException("Role name canot be null");
            }
            String filter = this.getRoleSearchFilter();
            log.debug((Object)("Search filter: " + filter));
            Object[] filterArgs = new Object[]{name};
            List sr = this.searchRoles(filter, filterArgs);
            if (sr.size() > 1) {
                throw new IdentityException("Found more than one role with id: " + name + "" + "Posible data inconsistency");
            }
            SearchResult res = (SearchResult)sr.iterator().next();
            DirContext ctx = (DirContext)res.getObject();
            return this.createRoleInstance(res.getAttributes(), ctx.getNameInNamespace());
        }
        catch (NoSuchElementException e) {
            log.debug((Object)("No role found with name: " + name), (Throwable)e);
        }
        catch (NamingException e) {
            throw new IdentityException("Role search failed.", e);
        }
        throw new IdentityException("No role found with name: " + name);
    }

    public Set findRolesByNames(String[] names) throws IdentityException, IllegalArgumentException {
        if (names == null) {
            throw new IllegalArgumentException("null argument");
        }
        HashSet<LDAPRoleImpl> roles = new HashSet<LDAPRoleImpl>();
        try {
            StringBuffer filter = new StringBuffer("(| ");
            String searchFilter = this.getRoleSearchFilter();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                String namedFilter = searchFilter.replaceAll("\\{0\\}", name);
                filter.append(namedFilter);
            }
            filter.append(")");
            List sr = this.searchRoles(filter.toString(), null);
            log.debug((Object)("Roles found: " + sr.size()));
            for (SearchResult res : sr) {
                DirContext ctx = (DirContext)res.getObject();
                roles.add(this.createRoleInstance(res.getAttributes(), ctx.getNameInNamespace()));
            }
        }
        catch (Exception e) {
            throw new IdentityException("Can't retreive roles", e);
        }
        return roles;
    }

    public Role createRole(String name, String displayName) throws IdentityException, IllegalArgumentException {
        throw new UnsupportedOperationException("Role management is not supported in this implementation of RoleModule");
    }

    public void removeRole(Object id) throws IdentityException, IllegalArgumentException {
        throw new UnsupportedOperationException("Role management is not supported in this implementation of RoleModule");
    }

    public int getRolesCount() throws IdentityException {
        try {
            String filter = this.getRoleSearchFilter();
            filter = filter.replaceAll("\\{0\\}", "*");
            log.debug((Object)("Search filter: " + filter));
            List sr = this.searchRoles(filter, null);
            return sr.size();
        }
        catch (NoSuchElementException e) {
            log.debug((Object)"No roles found", (Throwable)e);
        }
        catch (Exception e) {
            throw new IdentityException("Role search failed.", e);
        }
        return 0;
    }

    public Set findRoles() throws IdentityException {
        HashSet<LDAPRoleImpl> rf = new HashSet<LDAPRoleImpl>();
        try {
            String filter = this.getRoleSearchFilter();
            filter = filter.replaceAll("\\{0\\}", "*");
            log.debug((Object)("Search filter: " + filter));
            List results = this.searchRoles(filter, null);
            for (SearchResult res : results) {
                DirContext ctx = (DirContext)res.getObject();
                rf.add(this.createRoleInstance(res.getAttributes(), ctx.getNameInNamespace()));
            }
        }
        catch (NoSuchElementException e) {
            log.debug((Object)"No roles found", (Throwable)e);
        }
        catch (Exception e) {
            throw new IdentityException("Role search failed.", e);
        }
        return rf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List searchRoles(String filter, Object[] filterArgs) throws NamingException, IdentityException {
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        NamingEnumeration<SearchResult> results = null;
        try {
            Object filterArg;
            SearchControls controls = new SearchControls();
            controls.setSearchScope(this.getSearchScope());
            controls.setReturningObjFlag(true);
            controls.setTimeLimit(this.getSearchTimeLimit());
            String[] retAttr = new String[]{this.getRidAttributeID(), this.getDisplayNameAttributeID()};
            controls.setReturningAttributes(retAttr);
            filter = filter.replaceAll("\\\\", "\\\\\\\\");
            log.debug((Object)("Search filter: " + filter));
            if (log.isDebugEnabled() && filterArgs != null) {
                for (int i = 0; i < filterArgs.length; ++i) {
                    filterArg = filterArgs[i];
                    log.debug((Object)("Search filterArg: {" + i + "}: " + filterArg));
                }
            }
            log.debug((Object)("Search ctx: " + this.getRoleSearchCtxDNs()));
            Set roleCtxs = this.getRoleSearchCtxDNs();
            if (roleCtxs.size() == 1) {
                results = filterArgs == null ? ldapContext.search(this.getRoleCtxDN(), filter, controls) : ldapContext.search(this.getRoleCtxDN(), filter, filterArgs, controls);
                filterArg = Tools.toList(results);
                return filterArg;
            }
            LinkedList merged = new LinkedList();
            for (String roleCtx : roleCtxs) {
                results = filterArgs == null ? ldapContext.search(roleCtx, filter, controls) : ldapContext.search(roleCtx, filter, filterArgs, controls);
                merged.addAll(Tools.toList(results));
                results.close();
            }
            LinkedList linkedList = merged;
            return linkedList;
        }
        finally {
            if (results != null) {
                results.close();
            }
            ldapContext.close();
        }
    }

    protected Set getRoleSearchCtxDNs() throws IdentityException {
        Set searchCtx = this.getIdentityConfiguration().getValues("common", "roleCtxDN");
        if (searchCtx == null || searchCtx.size() == 0) {
            throw new IdentityException("userCtxDN missing in configuration");
        }
        return searchCtx;
    }
}

