/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import java.util.Comparator;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityConfiguration;
import org.jboss.portal.identity.IdentityContext;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.ldap.LDAPUserModule;

public class LDAPUserImpl
implements User {
    private static final Logger log = Logger.getLogger(LDAPUserImpl.class);
    IdentityContext identityContext;
    private UserProfileModule userProfileModule;
    private String dn;
    private String userName;
    private String id;
    LDAPUserModule userModule;

    private LDAPUserImpl() {
    }

    protected LDAPUserImpl(String dn, IdentityContext context, String id) throws IdentityException {
        if (dn == null) {
            throw new IdentityException("Cannot create LDAPUserImpl without DN");
        }
        this.dn = dn;
        if (context == null) {
            throw new IllegalArgumentException("IdentityContext can't be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id can't be null");
        }
        this.identityContext = context;
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return super.equals(obj);
        }
        User u = (User)obj;
        return u.getId().toString().equals(this.getId().toString());
    }

    public int hashCode() {
        return this.id.hashCode() * 13 + 5;
    }

    public void updatePassword(String password) throws IdentityException {
        if (password == null) {
            throw new IllegalArgumentException("Password is null");
        }
        try {
            this.getUserModule().updatePassword(this, password);
        }
        catch (IdentityException e) {
            log.debug((Object)("Password update failure: " + e));
            throw new IdentityException("Password update failure: " + e);
        }
    }

    public boolean validatePassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException("Password is null");
        }
        try {
            return this.getUserModule().validatePassword(this, password);
        }
        catch (IdentityException e) {
            log.debug((Object)("Password validation failure: " + e));
            return false;
        }
    }

    public String getDn() {
        return this.dn;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    public UserProfileModule getUserProfileModule() {
        return this.userProfileModule;
    }

    public void setUserProfileModule(UserProfileModule userProfileModule) {
        this.userProfileModule = userProfileModule;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    private IdentityConfiguration getIdentityConfiguration() throws IdentityException {
        return (IdentityConfiguration)this.identityContext.getObject("IdentityConfiguration");
    }

    protected LDAPUserModule getUserModule() throws IdentityException {
        if (this.userModule == null) {
            try {
                this.userModule = (LDAPUserModule)this.identityContext.getObject("User");
            }
            catch (ClassCastException e) {
                throw new IdentityException("Not supported object as part of the context - must be LDAPUserModule", e);
            }
        }
        return this.userModule;
    }

    public static class LDAPUserComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            User u1 = (User)o1;
            User u2 = (User)o2;
            String name1 = u1.getUserName();
            String name2 = u2.getUserName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

