/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.metadata.profile;

import java.util.Locale;
import org.jboss.logging.Logger;
import org.jboss.portal.common.i18n.LocaleFormat;
import org.jboss.portal.common.util.ConversionException;
import org.jboss.portal.identity.metadata.profile.LocalizedValueMetaData;
import org.jboss.portal.identity.metadata.profile.ProfileMetaData;
import org.jboss.portal.identity.metadata.profile.PropertyMappingDatabaseMetaData;
import org.jboss.portal.identity.metadata.profile.PropertyMappingLDAPMetaData;
import org.jboss.portal.identity.metadata.profile.PropertyMappingMetaData;
import org.jboss.portal.identity.metadata.profile.PropertyMetaData;
import org.jboss.xb.binding.GenericObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class ProfileMetaDataFactory
implements GenericObjectModelFactory {
    private static final Logger log = Logger.getLogger(ProfileMetaDataFactory.class);

    public Object newRoot(Object object, UnmarshallingContext unmarshallingContext, String string, String string1, Attributes attributes) {
        return new ProfileMetaData();
    }

    public Object completeRoot(Object root, UnmarshallingContext unmarshallingContext, String string, String string1) {
        return root;
    }

    public Object newChild(Object root, UnmarshallingContext nav, String nsURI, String localName, Attributes attrs) {
        if (root instanceof ProfileMetaData) {
            if ("property".equals(localName)) {
                return new PropertyMetaData();
            }
        } else if (root instanceof PropertyMetaData) {
            if ("mapping".equals(localName)) {
                return new PropertyMappingMetaData();
            }
            if ("description".equals(localName)) {
                String lang = attrs.getValue("xml:lang");
                LocalizedValueMetaData value = new LocalizedValueMetaData();
                if (lang != null) {
                    try {
                        Locale locale = LocaleFormat.DEFAULT.getLocale(lang);
                        value.setLocale(locale);
                    }
                    catch (ConversionException e) {
                        log.error((Object)"Cannot obtain language value", (Throwable)e);
                        return null;
                    }
                }
                return value;
            }
            if ("display-name".equals(localName)) {
                String lang = attrs.getValue("xml:lang");
                LocalizedValueMetaData value = new LocalizedValueMetaData();
                if (lang != null) {
                    try {
                        Locale locale = LocaleFormat.DEFAULT.getLocale(lang);
                        value.setLocale(locale);
                    }
                    catch (ConversionException e) {
                        log.error((Object)"Cannot obtain language value", (Throwable)e);
                        return null;
                    }
                }
                return value;
            }
        } else if (root instanceof PropertyMappingMetaData) {
            if ("database".equals(localName)) {
                return new PropertyMappingDatabaseMetaData();
            }
            if ("ldap".equals(localName)) {
                return new PropertyMappingLDAPMetaData();
            }
        }
        return null;
    }

    public void addChild(Object parent, Object child, UnmarshallingContext nav, String nsURI, String localName) {
        if (parent instanceof ProfileMetaData) {
            ProfileMetaData profile = (ProfileMetaData)parent;
            if (child instanceof PropertyMetaData) {
                profile.addProperty((PropertyMetaData)child);
            }
        } else if (parent instanceof PropertyMetaData) {
            PropertyMetaData describable = (PropertyMetaData)parent;
            if (child instanceof LocalizedValueMetaData) {
                if ("description".equals(localName)) {
                    describable.getDescription().getValues().add(child);
                } else if ("dispalay-name".equals(localName)) {
                    describable.getDisplayName().getValues().add(child);
                }
            } else if (child instanceof PropertyMappingMetaData) {
                describable.setMapping((PropertyMappingMetaData)child);
            }
        } else if (parent instanceof PropertyMappingMetaData) {
            PropertyMappingMetaData mapping = (PropertyMappingMetaData)parent;
            if (child instanceof PropertyMappingDatabaseMetaData) {
                mapping.setMappingDatabase((PropertyMappingDatabaseMetaData)child);
            } else if (child instanceof PropertyMappingLDAPMetaData) {
                mapping.setMappingLDAP((PropertyMappingLDAPMetaData)child);
            }
        }
    }

    public void setValue(Object object, UnmarshallingContext unmarshallingContext, String nsUri, String localName, String value) {
        if (object instanceof PropertyMetaData) {
            PropertyMetaData property = (PropertyMetaData)object;
            if ("name".equals(localName)) {
                property.setName(value);
            } else if ("type".equals(localName)) {
                property.setType(value);
            } else if ("access-mode".equals(localName)) {
                property.setAccessMode(value);
            } else if ("usage".equals(localName)) {
                property.setUsage(value);
            }
        } else if (object instanceof LocalizedValueMetaData) {
            LocalizedValueMetaData localized = (LocalizedValueMetaData)object;
            if ("description".equals(localName)) {
                localized.setValue(value);
            } else if ("display-name".equals(localName)) {
                localized.setValue(value);
            }
        } else if (object instanceof PropertyMappingDatabaseMetaData) {
            PropertyMappingDatabaseMetaData mapping = (PropertyMappingDatabaseMetaData)object;
            if ("type".equals(localName)) {
                mapping.setType(value);
            } else if ("value".equals(localName)) {
                mapping.setValue(value);
            }
        } else if (object instanceof PropertyMappingLDAPMetaData) {
            PropertyMappingLDAPMetaData mapping = (PropertyMappingLDAPMetaData)object;
            if ("value".equals(localName)) {
                mapping.setValue(value);
            }
        }
    }
}

