/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.metadata.service;

import org.jboss.portal.identity.metadata.config.ConfigurationParser;
import org.jboss.portal.identity.metadata.config.IdentityConfigurationMetaData;
import org.jboss.portal.identity.metadata.config.IdentityMetadataProcessor;
import org.jboss.portal.identity.metadata.service.DatasourceServicesMetaData;
import org.jboss.portal.identity.metadata.service.ModuleServicesMetaData;
import org.jboss.portal.identity.service.IdentityConfigurationService;

public class IdentityServicesMetaData {
    private DatasourceServicesMetaData datasourceServices;
    private ModuleServicesMetaData moduleServices;
    private IdentityConfigurationService configurationService;

    public IdentityServicesMetaData(String defaultConfigFile, String configFile) throws Exception {
        IdentityConfigurationMetaData meta = ConfigurationParser.parseIdentityConfiguration(configFile);
        IdentityConfigurationMetaData defaultMeta = ConfigurationParser.parseIdentityConfiguration(defaultConfigFile);
        this.datasourceServices = new DatasourceServicesMetaData(defaultMeta.getDatasources(), meta.getDatasources());
        this.moduleServices = new ModuleServicesMetaData(defaultMeta.getModules(), meta.getModules());
        this.configurationService = new IdentityConfigurationService(meta.getOptions());
        IdentityMetadataProcessor.updateOptionsWithDefaults(this.configurationService, defaultMeta.getOptions());
    }

    public DatasourceServicesMetaData getDatasourceServices() {
        return this.datasourceServices;
    }

    public ModuleServicesMetaData getModuleServices() {
        return this.moduleServices;
    }

    public IdentityConfigurationService getConfigurationService() {
        return this.configurationService;
    }
}

