/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityConfiguration;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.metadata.config.OptionsGroupMetaData;
import org.jboss.portal.identity.metadata.config.OptionsGroupOptionMetaData;
import org.jboss.portal.identity.metadata.config.OptionsMetaData;
import org.jboss.portal.identity.service.IdentityModuleService;

public class IdentityConfigurationService
extends IdentityModuleService
implements IdentityConfiguration {
    private static final Logger log = Logger.getLogger(IdentityConfigurationService.class);
    private Map data;

    public IdentityConfigurationService() {
        super("IdentityConfiguration");
    }

    public IdentityConfigurationService(Map optionGroups) {
        this();
        this.data = optionGroups;
    }

    public IdentityConfigurationService(OptionsMetaData meta) throws IdentityException {
        this();
        if (meta == null || meta.getGroups() == null) {
            this.data = new HashMap();
            return;
        }
        try {
            HashMap newGroups = new HashMap();
            Map groups = meta.getGroups();
            for (String groupKey : groups.keySet()) {
                OptionsGroupMetaData group = (OptionsGroupMetaData)groups.get(groupKey);
                HashMap<String, Set> newOptions = new HashMap<String, Set>();
                Map options = group.getOptions();
                for (String optionKey : options.keySet()) {
                    OptionsGroupOptionMetaData option = (OptionsGroupOptionMetaData)options.get(optionKey);
                    newOptions.put(option.getName(), option.getValues());
                }
                newGroups.put(group.getName(), newOptions);
            }
            this.setData(newGroups);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot create identity configuration options data:", e);
        }
    }

    public Set getValues(String optionGroup, String option) {
        Map group;
        if (optionGroup == null) {
            throw new IllegalArgumentException("null option group");
        }
        if (option == null) {
            throw new IllegalArgumentException("null option name");
        }
        if (this.data.containsKey(optionGroup) && (group = (Map)this.data.get(optionGroup)).containsKey(option)) {
            return (Set)group.get(option);
        }
        return null;
    }

    public String getValue(String optionGroup, String option) {
        Set values;
        Map group;
        if (optionGroup == null) {
            throw new IllegalArgumentException("null option group");
        }
        if (option == null) {
            throw new IllegalArgumentException("null option name");
        }
        if (this.data.containsKey(optionGroup) && (group = (Map)this.data.get(optionGroup)).containsKey(option) && (values = (Set)group.get(option)).size() > 0) {
            return (String)values.toArray()[0];
        }
        return null;
    }

    public String getValue(String option) {
        Set values;
        Map group;
        if (option == null) {
            throw new IllegalArgumentException("null option name");
        }
        if (this.data.containsKey("common") && (group = (Map)this.data.get("common")).containsKey(option) && (values = (Set)group.get(option)).size() > 0) {
            return (String)values.toArray()[0];
        }
        return null;
    }

    public void setValues(String optionGroup, String option, Set values) {
        if (optionGroup == null) {
            throw new IllegalArgumentException("null option group");
        }
        if (option == null) {
            throw new IllegalArgumentException("null option name");
        }
        if (values == null) {
            throw new IllegalArgumentException("null values list");
        }
        if (this.data.containsKey(optionGroup)) {
            ((Map)this.data.get(optionGroup)).put(option, values);
        }
    }

    public void addValue(String optionGroup, String option, String value) {
        Map group;
        if (optionGroup == null) {
            throw new IllegalArgumentException("null option group");
        }
        if (option == null) {
            throw new IllegalArgumentException("null option name");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value name");
        }
        if (this.data.containsKey(optionGroup) && (group = (Map)this.data.get(optionGroup)).containsKey(option)) {
            ((Set)group.get(option)).add(value);
        }
    }

    public Map getOptions(String optionGroup) {
        if (optionGroup == null) {
            throw new IllegalArgumentException("null option group");
        }
        if (this.data.containsKey(optionGroup)) {
            return (Map)this.data.get(optionGroup);
        }
        return null;
    }

    public void setOptions(String optionGroup, Map options) {
        if (optionGroup == null) {
            throw new IllegalArgumentException("null option group");
        }
        if (options == null) {
            throw new IllegalArgumentException("null options map");
        }
        this.data.put(optionGroup, options);
    }

    public void remoeOption(String optionGroup, String option) {
        if (optionGroup == null) {
            throw new IllegalArgumentException("null option group");
        }
        if (option == null) {
            throw new IllegalArgumentException("null option name");
        }
        if (this.data.containsKey(optionGroup)) {
            ((Map)this.data.get(optionGroup)).put(option, null);
        }
    }

    public void setData(Map data) {
        this.data = data;
    }

    public Map getOptionGroups() {
        return this.data;
    }
}

