/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.service;

import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.identity.event.RoleCreatedEvent;
import org.jboss.portal.identity.event.RoleDestroyedEvent;
import org.jboss.portal.identity.event.RoleUpdatedEvent;
import org.jboss.portal.identity.service.IdentityModuleService;

public abstract class RoleModuleService
extends IdentityModuleService
implements RoleModule {
    private static final Logger log = Logger.getLogger(RoleModuleService.class);

    protected RoleModuleService() {
        super("Role");
    }

    protected void fireRoleCreatedEvent(Object roleId, String roleName) throws IdentityException {
        RoleCreatedEvent event = new RoleCreatedEvent(roleId, roleName);
        this.getIdentityEventBroadcaster().fireEvent(event);
    }

    protected void fireRoleDestroyedEvent(Object roleId, String roleName) throws IdentityException {
        RoleDestroyedEvent event = new RoleDestroyedEvent(roleId, roleName);
        this.getIdentityEventBroadcaster().fireEvent(event);
    }

    protected void fireRoleUpdatedEvent(Object roleId, String roleName, String displayName) throws IdentityException {
        RoleUpdatedEvent event = new RoleUpdatedEvent(roleId, roleName, displayName);
        this.getIdentityEventBroadcaster().fireEvent(event);
    }
}

