/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.richfaces.simple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import org.richfaces.component.SortOrder;

@ManagedBean
@ViewScoped
public class UserSorter
implements Serializable {
    private static final long serialVersionUID = -9189227920939669284L;
    private Map<String, SortOrder> sortsOrders = new HashMap();
    private List<String> sortPriorities = new ArrayList();
    private boolean multipleSorting = false;
    private static final String SORT_PROPERTY_PARAMETER = "sortProperty";

    public void sort() {
        String property = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get(SORT_PROPERTY_PARAMETER);
        if (property != null) {
            SortOrder currentPropertySortOrder = (SortOrder)this.sortsOrders.get(property);
            if (this.multipleSorting) {
                if (!this.sortPriorities.contains(property)) {
                    this.sortPriorities.add(property);
                }
            } else {
                this.sortsOrders.clear();
            }
            if (currentPropertySortOrder == null || currentPropertySortOrder.equals((Object)SortOrder.descending)) {
                this.sortsOrders.put(property, SortOrder.ascending);
            } else {
                this.sortsOrders.put(property, SortOrder.descending);
            }
        }
    }

    public void modeChanged(ValueChangeEvent event) {
        this.reset();
    }

    public void reset() {
        this.sortPriorities.clear();
        this.sortsOrders.clear();
    }

    public boolean isMultipleSorting() {
        return this.multipleSorting;
    }

    public void setMultipleSorting(boolean multipleSorting) {
        this.multipleSorting = multipleSorting;
    }

    public List<String> getSortPriorities() {
        return this.sortPriorities;
    }

    public Map<String, SortOrder> getSortsOrders() {
        return this.sortsOrders;
    }
}

