/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.richfaces.simple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.jboss.portletbridge.richfaces.simple.User;
import org.jboss.portletbridge.richfaces.simple.UserType;

@ManagedBean
@ApplicationScoped
public class UserManager
implements Serializable {
    private static final long serialVersionUID = 5172630160799032072L;
    private transient List<SelectItem> userTypeOptions = null;
    private Set<User> users = new HashSet();
    private boolean usersLoaded = false;

    @PostConstruct
    public void init() {
        this.userTypeOptions = new ArrayList();
        for (UserType userType : UserType.values()) {
            this.userTypeOptions.add(new SelectItem((Object)userType, userType.name()));
        }
        if (!this.usersLoaded) {
            this.users.add(new User("Gary", "Ablett", "gary.ablett@gmail.com", UserType.USER));
            this.users.add(new User("Mickey", "Mouse", "mickey.mouse@gmail.com", UserType.USER));
            this.users.add(new User("Geoff", "Mornay", "geoff.mornay@gmail.com", UserType.USER));
            this.users.add(new User("Peter", "Pan", "peter.pan@gmail.com", UserType.ADMIN));
            this.usersLoaded = true;
        }
    }

    public List<User> getUsers() {
        return new ArrayList<User>(this.users);
    }

    public boolean addUser(User user) {
        boolean result = this.users.add(user);
        if (result) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "User saved", "You were succesful in saving the new User"));
        } else {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, "User already saved", "You attempted to save a User that had previously been saved"));
        }
        return result;
    }

    public List<SelectItem> getUserTypeOptions() {
        if (null == this.userTypeOptions) {
            this.init();
        }
        return this.userTypeOptions;
    }
}

