/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.richfaces.simple;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.jboss.portletbridge.richfaces.simple.UserType;

public class User
implements Serializable {
    private static final long serialVersionUID = 7530955664685217593L;
    @NotNull
    @Size(min=3, max=20)
    private String firstName;
    @NotNull
    @Size(min=3, max=40)
    private String lastName;
    @NotNull
    @Pattern(regexp="^[\\w\\-]([\\.\\w])+[\\w]+@([\\w\\-]+\\.)+[a-zA-Z]{2,4}$", message="Bad email")
    private String email;
    @NotNull
    private UserType userType;

    public User() {
    }

    public User(String first, String last, String email, UserType type) {
        this.firstName = first;
        this.lastName = last;
        this.email = email;
        this.userType = type;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        if (null == this.firstName ? null != other.firstName : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (null == this.lastName ? null != other.lastName : !this.lastName.equals(other.lastName)) {
            return false;
        }
        if (null == this.email ? null != other.email : !this.email.equals(other.email)) {
            return false;
        }
        return !(null == this.userType ? null != other.userType : !this.userType.equals((Object)other.userType));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (null == this.firstName ? 0 : this.firstName.hashCode()) + (null == this.lastName ? 0 : this.lastName.hashCode()) + (null == this.email ? 0 : this.email.hashCode());
        return result;
    }
}

