/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.domain;

import java.util.List;

import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.jboss.profileservice.domain.resources.JdbcResource;
import org.jboss.profileservice.domain.resources.JmsResource;
import org.jboss.profileservice.domain.resources.QueueResource;
import org.jboss.profileservice.domain.resources.TopicResource;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragment;
import org.jboss.profileservice.domain.spi.DomainMetaData;
import org.jboss.profileservice.domain.threadpool.ThreadsMetaData;
import org.jboss.xb.annotations.JBossXmlNsPrefix;
import org.jboss.xb.annotations.JBossXmlSchema;

/**
 * The domain meta data.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 103976 $
 */
@JBossXmlSchema(namespace=DomainMetaData.DOMAIN_NAMESPACE,
      elementFormDefault=XmlNsForm.QUALIFIED,
      normalizeSpace=true,
      replacePropertyRefs=true,
      xmlns={@XmlNs(namespaceURI=DomainMetaData.SERVER_NAMESPACE, prefix="server"),
      @XmlNs(namespaceURI=DomainMetaData.JDBC_RESOURCES_NAMESPACE, prefix="jdbc"),
      @XmlNs(namespaceURI=DomainMetaData.JMS_RESOURCES_NAMESPACE, prefix="jms"),
      @XmlNs(namespaceURI=DomainMetaData.THREADS_NAMESPACE, prefix="tp")})
@XmlRootElement(name = "domain")
@XmlType(name = "domainType", propOrder = {"server", "jdbcResources", "jmsResources", "threads", "fragments"})
public class AbstractDomainMetaData implements DomainMetaData
{

   /** The management domain information. */
   private ManagementDomainMetaData domain;
   
   /** The local server information. */
   private ServerMetaData server;

   /** The thread pools of the domain. */
   private ThreadsMetaData threadPools;
   private List<JdbcResource> jdbcResources;
   private List<JmsResource> jmsResources;

   /** The elements of the domain. */
   private List<DomainMetaDataFragment> fragments;
   
   /**
    * Get the management domain information.
    * 
    * @return the domain meta data
    */
   @XmlTransient
   public ManagementDomainMetaData getDomain()
   {
      return domain;
   }
   
   public void setDomain(ManagementDomainMetaData domain)
   {
      this.domain = domain;
   }

   /**
    * Get the server meta data.
    * 
    * @return the server meta data
    */
   @JBossXmlNsPrefix(prefix="server")
   public ServerMetaData getServer()
   {
      return server;
   }

   public void setServer(ServerMetaData server)
   {
      this.server = server;
   }

   @XmlElementWrapper(name="jdbc-resources", namespace=DomainMetaData.JDBC_RESOURCES_NAMESPACE)
   @XmlElement(name="jdbc-resource")
   @JBossXmlNsPrefix(prefix="jdbc")
   public List<JdbcResource> getJdbcResources()
   {
      return jdbcResources;
   }
   public void setJdbcResources(List<JdbcResource> jdbcResources)
   {
      this.jdbcResources = jdbcResources;
   }

   @XmlElement(name="threads", namespace=DomainMetaData.THREADS_NAMESPACE)
   @JBossXmlNsPrefix(prefix="tp")
   public ThreadsMetaData getThreads()
   {
      return threadPools;
   }
   public void setThreads(ThreadsMetaData threadPools)
   {
      this.threadPools = threadPools;
   }

   @XmlElementWrapper(name="jms-resources", namespace=DomainMetaData.JMS_RESOURCES_NAMESPACE)
   @XmlElements({
         @XmlElement(name="queue", type=QueueResource.class),
         @XmlElement(name="topic", type=TopicResource.class)
   })
   @JBossXmlNsPrefix(prefix="jms")
   public List<JmsResource> getJmsResources()
   {
      return jmsResources;
   }
   public void setJmsResources(List<JmsResource> jmsResources)
   {
      this.jmsResources = jmsResources;
   }

   /**
    * Get the domain elements.
    * 
    * @return the elements
    */
   @XmlAnyElement
   public List<DomainMetaDataFragment> getFragments()
   {
      return fragments;
   }

   public void setFragments(List<DomainMetaDataFragment> elements)
   {
      this.fragments = elements;
   }
   
}
