/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.domain.resources;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.jboss.profileservice.domain.PropertiesMetaData;
import org.jboss.profileservice.domain.spi.DomainMetaData;
import org.jboss.xb.annotations.JBossXmlSchema;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
@JBossXmlSchema(namespace=DomainMetaData.JDBC_RESOURCES_NAMESPACE,
      elementFormDefault=XmlNsForm.QUALIFIED,
      normalizeSpace=true,
      replacePropertyRefs=true
)
@XmlType(name="jdbcResType", propOrder={})
public class JdbcResource
{
   private String jndiName;
   private String poolName;
   private boolean enabled;
   private String connectionUrl;
   private String driverClass;
   private String typeMapping;
   private int minPoolSize;
   private int maxPoolSize;
   private String username;
   private String password;
   private TransactionIsolation transactionIsolation;
   private PropertiesMetaData properties;

   @XmlAttribute(name="jndi-name")
   public String getJndiName()
   {
      return jndiName;
   }
   public void setJndiName(String jndiName)
   {
      this.jndiName = jndiName;
   }
   @XmlAttribute(name="pool-name")
   public String getPoolName()
   {
      return poolName;
   }
   public void setPoolName(String poolName)
   {
      this.poolName = poolName;
   }
   @XmlAttribute(name="enabled")
   public boolean isEnabled()
   {
      return enabled;
   }
   public void setEnabled(boolean enabled)
   {
      this.enabled = enabled;
   }

   public String getConnectionUrl()
   {
      return connectionUrl;
   }
   public void setConnectionUrl(String connectionUrl)
   {
      this.connectionUrl = connectionUrl;
   }
   public String getDriverClass()
   {
      return driverClass;
   }
   public void setDriverClass(String driverClass)
   {
      this.driverClass = driverClass;
   }
   public String getTypeMapping()
   {
      return typeMapping;
   }
   public void setTypeMapping(String typeMapping)
   {
      this.typeMapping = typeMapping;
   }
   public int getMinPoolSize()
   {
      return minPoolSize;
   }
   public void setMinPoolSize(int minPoolSize)
   {
      this.minPoolSize = minPoolSize;
   }
   public int getMaxPoolSize()
   {
      return maxPoolSize;
   }
   public void setMaxPoolSize(int maxPoolSize)
   {
      this.maxPoolSize = maxPoolSize;
   }
   public String getUsername()
   {
      return username;
   }
   public void setUsername(String username)
   {
      this.username = username;
   }
   public String getPassword()
   {
      return password;
   }
   public void setPassword(String password)
   {
      this.password = password;
   }

   public TransactionIsolation getTransactionIsolation()
   {
      return transactionIsolation;
   }
   public void setTransactionIsolation(TransactionIsolation transactionIsolation)
   {
      this.transactionIsolation = transactionIsolation;
   }
   @XmlElementWrapper(name="properties")
   public PropertiesMetaData getProperties()
   {
      return properties;
   }
   public void setProperties(PropertiesMetaData properties)
   {
      this.properties = properties;
   } 
}
