/*
* JBoss, Home of Professional Open Source
* Copyright 2009, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.domain.spi;

import java.util.List;

/**
 * The domain meta data.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface DomainMetaData
{

   /** The domain xml namespace. */
   String DOMAIN_NAMESPACE = "urn:jboss:profileservice:domain:1.0";
   /** The server xml namespace. */
   String SERVER_NAMESPACE = "urn:jboss:profileservice:server:1.0";
   /** The jdbc resources xml namespace. */
   String JDBC_RESOURCES_NAMESPACE = "urn:jboss:profileservice:jdbc-resources:1.0";
   /** The jms resources xml namespace. */
   String JMS_RESOURCES_NAMESPACE = "urn:jboss:profileservice:jms-resources:1.0";
   /** The threads xml namespace. */
   String THREADS_NAMESPACE = "urn:jboss:profileservice:threads:1.0";
   
   /**
    * Get the domain features.
    * 
    * @return the features.
    */
   List<DomainMetaDataFragment> getFragments();

   /**
    * Visit all {@code DomainMetaDataFragment}s in the {@code DomainMetaData}. 
    * 
    * @param visitor the fragment visitor
    */
   void visit(DomainMetaDataFragmentVisitor visitor);
   
}

