/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

import org.jboss.xb.annotations.JBossXmlMapEntry;
import org.jboss.xb.annotations.JBossXmlMapKeyAttribute;
import org.jboss.xb.annotations.JBossXmlMapValueAttribute;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
@XmlType(name="mapType", propOrder={})
@JBossXmlMapEntry(name="entry")
@JBossXmlMapKeyAttribute(name="key")
@JBossXmlMapValueAttribute(name="value")
public class PropertiesMetaData implements Serializable,
   Map<String, String>
{
   private static final long serialVersionUID = 2L;

   /** The map */
   private HashMap<String, String> props = new HashMap<String, String>();
   /** The key type */
   protected String keyType;

   /** The value type */
   protected String valueType;

   /**
    * Get the key type
    * 
    * @return the key type
    */
   public String getKeyType()
   {
      return keyType;
   }

   /**
    * Set the key type
    * 
    * @param keyType the key type
    */
   @XmlAttribute(name="keyClass")
   public void setKeyType(String keyType)
   {
      this.keyType = keyType;
   }

   /**
    * Get the value type
    * 
    * @return the value type
    */
   public String getValueType()
   {
      return valueType;
   }

   /**
    * Set the value type
    * 
    * @param valueType the value type
    */
   @XmlAttribute(name="valueClass")
   public void setValueType(String valueType)
   {
      this.valueType = valueType;
   }

   @Override
   public void clear()
   {
      props.clear();
   }

   @Override
   public boolean containsKey(Object key)
   {
      return props.containsKey(key);
   }

   @Override
   public boolean containsValue(Object value)
   {
      return props.containsValue(value);
   }

   @Override
   public Set<java.util.Map.Entry<String, String>> entrySet()
   {
      return props.entrySet();
   }

   @Override
   public String get(Object key)
   {
      return props.get(key);
   }

   @Override
   public boolean isEmpty()
   {
      return props.isEmpty();
   }

   @Override
   public Set<String> keySet()
   {
      return props.keySet();
   }

   @Override
   public String put(String key, String value)
   {
      return props.put(key, value);
   }

   @Override
   public void putAll(Map<? extends String, ? extends String> t)
   {
      props.putAll(t);
   }

   @Override
   public String remove(Object key)
   {
      return props.remove(key);
   }

   @Override
   public int size()
   {
      return props.size();
   }

   @Override
   public Collection<String> values()
   {
      return props.values();
   }
}
