/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.deploy.actions;

import java.io.InputStream;
import java.io.SyncFailedException;
import java.util.Arrays;
import org.jboss.deployers.spi.management.deploy.DeploymentID;
import org.jboss.profileservice.management.event.ProfileModificationEvent;
import org.jboss.profileservice.plugins.deploy.actions.AbstractDeploymentAddAction;
import org.jboss.profileservice.profile.metadata.BasicProfileDeploymentMetaData;
import org.jboss.profileservice.repository.artifact.CopyStreamArtifactTransformer;
import org.jboss.profileservice.repository.artifact.ExplodedArtifactTransformer;
import org.jboss.profileservice.repository.artifact.file.FileArtifactId;
import org.jboss.profileservice.spi.DeploymentOption;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.VirtualDeploymentRepositoryExt;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.action.deployment.DeploymentAction;
import org.jboss.profileservice.spi.action.deployment.DeploymentActionContext;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentFlag;
import org.jboss.profileservice.spi.repository.ArtifactId;
import org.jboss.profileservice.spi.repository.ArtifactRepository;
import org.jboss.profileservice.spi.repository.ArtifactTransformer;
import org.jboss.profileservice.spi.repository.MutableArtifactRepository;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;

public class DeploymentDistributeAction
extends AbstractDeploymentAddAction
implements DeploymentAction<DeploymentActionContext> {
    private static final FileArtifactId noopArtifactId = FileArtifactId.EMPTY_ARTIFACT;
    private final InputStream contentIS;

    public DeploymentDistributeAction(MutableProfile profile, DeploymentID dtId, InputStream is, DeploymentActionContext modificationContext) {
        super(dtId, profile, modificationContext);
        this.contentIS = is;
    }

    protected boolean doPrepare(ProfileModificationResponse response) {
        try {
            VirtualDeploymentRepository deploymentRepository;
            String deploymentName = this.getDeploymentName();
            if (this.getProfile().hasDeployment(deploymentName)) {
                ProfileDeployment deployment = this.getProfile().getDeployment(deploymentName);
                deployment.getDeploymentInfo().setFlag(ProfileDeploymentFlag.LOCKED);
            }
            if ((deploymentRepository = DeploymentDistributeAction.resolveDeploymentRepository(this.getProfile())) == null) {
                response.setFailure((Throwable)new IllegalStateException("failed to resolve deployment repository"));
                return false;
            }
            MutableArtifactRepository<FileArtifactId> artifactRepository = DeploymentDistributeAction.resolveRepository(deploymentRepository);
            String artifactName = deploymentName;
            FileArtifactId artifactId = new FileArtifactId(artifactName);
            if (this.isFailIfExists() && artifactRepository.containsArtifact((ArtifactId)artifactId)) {
                response.setFailure((Throwable)new SyncFailedException("Deployment content already exists: " + artifactName));
                return false;
            }
            ArtifactTransformer transformer = null;
            transformer = this.isExplode() ? ExplodedArtifactTransformer.getInstance() : CopyStreamArtifactTransformer.getInstance();
            artifactRepository.addArtifact((ArtifactId)artifactId, this.contentIS, transformer);
            ProfileDeployment deployment = deploymentRepository.createDeployment((VirtualDeploymentMetaData)new BasicProfileDeploymentMetaData(artifactName));
            deployment.getDeploymentInfo().setFlag(ProfileDeploymentFlag.LOCKED);
            this.getProfile().addDeployment(deployment);
            response.fireModificationEvent(ProfileModificationEvent.create((ProfileModificationType)ProfileModificationType.ADD, (ProfileKey)this.getProfile().getKey()));
        }
        catch (Exception e) {
            response.setFailure((Throwable)e);
            return false;
        }
        return true;
    }

    protected ArtifactTransformer<FileArtifactId> createTransformer() {
        if (this.isExplode()) {
            return ExplodedArtifactTransformer.getInstance();
        }
        return CopyStreamArtifactTransformer.getInstance();
    }

    protected void doCancel() {
    }

    protected void doCommit(ProfileModificationResponse response) {
    }

    protected void doComplete(ProfileModificationResponse response) throws Exception {
    }

    protected void doRollbackFromCancelled() {
    }

    protected void doRollbackFromComplete() {
    }

    protected void doRollbackFromActive() {
    }

    protected void doRollbackFromPrepared() {
    }

    protected void doRollbackFromRollbackOnly() {
    }

    protected boolean isExplode() {
        return this.hasDeploymentOption(DeploymentOption.Explode);
    }

    protected boolean isFailIfExists() {
        return this.hasDeploymentOption(DeploymentOption.FailIfExists);
    }

    protected boolean hasDeploymentOption(DeploymentOption option) {
        if (this.getDeploymentID().getDeploymentOptions() != null) {
            return Arrays.binarySearch(this.getDeploymentID().getDeploymentOptions(), option) != -1;
        }
        return false;
    }

    static VirtualDeploymentRepository resolveDeploymentRepository(MutableProfile profile) {
        if (!(profile instanceof VirtualDeploymentRepositoryExt)) {
            throw new IllegalStateException("Failed to get the deployment repository for profile " + profile.getKey());
        }
        return ((VirtualDeploymentRepositoryExt)VirtualDeploymentRepositoryExt.class.cast(profile)).getDeploymentRepository();
    }

    static MutableArtifactRepository<FileArtifactId> resolveRepository(VirtualDeploymentRepository deploymentRepository) {
        ArtifactRepository repo = deploymentRepository.resolveArtifactRepository((ArtifactId)noopArtifactId);
        if (!(repo instanceof MutableArtifactRepository)) {
            throw new IllegalStateException("no mutable artifact repository");
        }
        return (MutableArtifactRepository)MutableArtifactRepository.class.cast(repo);
    }
}

