/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.deploy.actions;

import org.jboss.profileservice.management.actions.AbstractTwoPhaseModificationAction;
import org.jboss.profileservice.management.event.ProfileModificationEvent;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.VirtualDeploymentRepositoryExt;
import org.jboss.profileservice.spi.action.ProfileModificationContext;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.action.deployment.DeploymentAction;
import org.jboss.profileservice.spi.action.deployment.DeploymentActionContext;
import org.jboss.profileservice.spi.managed.ManagedProfile;
import org.jboss.profileservice.spi.repository.ArtifactId;
import org.jboss.profileservice.spi.repository.ArtifactRepository;
import org.jboss.profileservice.spi.repository.MutableArtifactRepository;

public class DeploymentRemoveAction
extends AbstractTwoPhaseModificationAction<DeploymentActionContext>
implements DeploymentAction<DeploymentActionContext> {
    private String deploymentName;
    private ManagedProfile managed;

    public DeploymentRemoveAction(ManagedProfile managed, String deploymentName, DeploymentActionContext modificationContext) {
        super((ProfileModificationContext)modificationContext);
        this.managed = managed;
        this.deploymentName = deploymentName;
    }

    protected void doCancel() {
    }

    protected void doCommit(ProfileModificationResponse response) {
    }

    protected void doComplete(ProfileModificationResponse response) throws Exception {
    }

    protected boolean doPrepare(ProfileModificationResponse response) {
        try {
            MutableArtifactRepository<ArtifactId> repository;
            if (!this.managed.getProfile().isMutable() || !(this.managed.getProfile() instanceof MutableProfile)) {
                return false;
            }
            MutableProfile profile = (MutableProfile)MutableProfile.class.cast(this.managed.getProfile());
            ProfileDeployment deployment = profile.getDeployment(this.deploymentName);
            ArtifactId artifactId = this.resolveArtifactMetaData(deployment);
            if (artifactId != null && (repository = this.resolveArtifactRepository(profile, deployment)) != null) {
                repository.removeArtifact(artifactId);
            }
            profile.removeDeployment(deployment.getName());
            response.fireModificationEvent(ProfileModificationEvent.create((ProfileModificationType)ProfileModificationType.DELETE, (ProfileKey)this.managed.getProfileKey()));
        }
        catch (Exception e) {
            response.setFailure((Throwable)e);
            return false;
        }
        return true;
    }

    protected void doRollbackFromActive() {
    }

    protected void doRollbackFromCancelled() {
    }

    protected void doRollbackFromComplete() {
    }

    protected void doRollbackFromPrepared() {
    }

    protected void doRollbackFromRollbackOnly() {
    }

    MutableArtifactRepository<ArtifactId> resolveArtifactRepository(MutableProfile profile, ProfileDeployment deployment) {
        VirtualDeploymentRepository deploymentRepository = this.resolveVirtualDeploymentRepository(profile);
        if (deploymentRepository == null) {
            return null;
        }
        ArtifactId artifactId = this.resolveArtifactMetaData(deployment);
        if (artifactId == null) {
            return null;
        }
        ArtifactRepository repository = deploymentRepository.resolveArtifactRepository(artifactId);
        if (repository != null && repository instanceof MutableArtifactRepository) {
            return (MutableArtifactRepository)MutableArtifactRepository.class.cast(repository);
        }
        return null;
    }

    VirtualDeploymentRepository resolveVirtualDeploymentRepository(MutableProfile profile) {
        if (profile instanceof VirtualDeploymentRepositoryExt) {
            return ((VirtualDeploymentRepositoryExt)VirtualDeploymentRepositoryExt.class.cast(profile)).getDeploymentRepository();
        }
        return null;
    }

    ArtifactId resolveArtifactMetaData(ProfileDeployment deployment) {
        return deployment.getDeploymentInfo().getMetaData().getArtifact();
    }
}

