/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.deploy.actions;

import java.util.Collection;
import org.jboss.profileservice.management.event.ProfileModificationEvent;
import org.jboss.profileservice.plugins.deploy.actions.AbstractDeploymentLifeCycleAction;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.action.deployment.DeploymentAction;
import org.jboss.profileservice.spi.action.deployment.DeploymentActionContext;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentFlag;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentInfo;
import org.jboss.profileservice.spi.managed.ManagedProfile;
import org.jboss.profileservice.spi.managed.ManagedProfileDeployer;

public class DeploymentStopAction
extends AbstractDeploymentLifeCycleAction
implements DeploymentAction<DeploymentActionContext> {
    public DeploymentStopAction(ManagedProfile managed, Collection<String> names, DeploymentActionContext modificationContext) {
        super(managed, names, modificationContext);
    }

    protected void doCancel() {
    }

    protected void doCommit(ProfileModificationResponse response) {
        for (AbstractDeploymentLifeCycleAction.DeploymentState state : this.getDeployments()) {
            ProfileDeploymentInfo info = state.getDeployment().getDeploymentInfo();
            info.clearFlag(ProfileDeploymentFlag.DEPLOYED);
        }
    }

    protected void doComplete(ProfileModificationResponse response) throws Exception {
    }

    protected boolean doPrepare(ProfileModificationResponse response) {
        try {
            Profile profile = this.getManagedProfile().getProfile();
            ManagedProfileDeployer deployer = this.getManagedProfile().getManagedDeployer();
            for (String deploymentName : this.getDeploymentNames()) {
                ProfileDeployment deployment = profile.getDeployment(deploymentName);
                ProfileDeploymentInfo info = deployment.getDeploymentInfo();
                info.setFlag(ProfileDeploymentFlag.LOCKED);
                deployer.removeDeployment(deployment);
                this.addDeployment(deployment);
            }
            deployer.process();
            response.fireModificationEvent(ProfileModificationEvent.create((ProfileModificationType)ProfileModificationType.DELETE, (ProfileKey)this.getManagedProfile().getProfileKey()));
        }
        catch (Exception e) {
            response.setFailure((Throwable)e);
            return false;
        }
        return true;
    }

    protected void doRollbackFromActive() {
    }

    protected void doRollbackFromCancelled() {
    }

    protected void doRollbackFromComplete() {
    }

    protected void doRollbackFromPrepared() {
    }

    protected void doRollbackFromRollbackOnly() {
    }
}

