/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.management.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.MutableManagedComponent;
import org.jboss.managed.api.RunState;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementObjectRef;
import org.jboss.managed.plugins.ManagedComponentImpl;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.profileservice.plugins.spi.ProfileViewProcessingContext;

public abstract class ManagedObjectProcessor {
    private static final Logger log = Logger.getLogger(ManagedObjectProcessor.class);
    private Map<String, ManagedObject> moRegistry = new HashMap<String, ManagedObject>();
    private Map<String, Set<ManagedProperty>> unresolvedRefs = new HashMap<String, Set<ManagedProperty>>();

    protected abstract RunState updateRunState(ManagedObject var1, ManagedComponent var2);

    protected abstract MutableManagedComponent createManagedComponentProxy(Object var1, MutableManagedComponent var2);

    public void processManagedObject(ManagedObject mo, ManagedDeployment md, ProfileViewProcessingContext context) throws Exception {
        ManagementComponent mc;
        boolean trace = log.isTraceEnabled();
        String key = mo.getName() + "/" + mo.getNameType();
        if (trace) {
            log.trace((Object)("ID for ManagedObject: " + key + ", attachmentName: " + mo.getAttachmentName()));
        }
        if ((mc = this.getAnnotation(mo, ManagementComponent.class)) != null) {
            ComponentType type = new ComponentType(mc.type(), mc.subtype());
            ManagedComponentImpl comp = new ManagedComponentImpl(type, md, mo);
            if (comp.getComponentName() != null) {
                comp = this.createManagedComponentProxy(comp.getComponentName(), (MutableManagedComponent)comp);
            }
            if (trace) {
                log.trace((Object)("Processing ManagementComponent(" + mo.getName() + "): " + comp));
            }
            if (md != null && md.getComponent(mo.getName()) == null) {
                md.addComponent(mo.getName(), (ManagedComponent)comp);
            }
            context.addManagedComponent((ManagedComponent)comp);
            this.updateRunState(null, (ManagedComponent)comp);
        }
        this.processManagedObject(key, mo, md, context);
    }

    protected ManagedObject getRegisteredManagedObject(String key) {
        return this.moRegistry.get(key);
    }

    protected void processManagedObject(String key, ManagedObject mo, ManagedDeployment md, ProfileViewProcessingContext context) throws Exception {
        boolean trace = log.isTraceEnabled();
        this.checkForReferences(key, mo);
        for (ManagedProperty prop : mo.getProperties().values()) {
            ArrayValue avalue;
            MetaType etype;
            ArrayMetaType amt;
            MetaType propType;
            Map pannotations = prop.getAnnotations();
            if (pannotations != null && !pannotations.isEmpty()) {
                ManagementObjectRef ref;
                ManagementObjectID id = (ManagementObjectID)pannotations.get(ManagementObjectID.class.getName());
                if (id != null) {
                    Object refName = this.getRefName(prop.getValue());
                    if (refName == null) {
                        refName = id.name();
                    }
                    String propKey = refName + "/" + id.type();
                    if (trace) {
                        log.trace((Object)("ManagedProperty level ID for ManagedObject: " + propKey + ", attachmentName: " + mo.getAttachmentName()));
                    }
                    this.moRegistry.put(propKey, mo);
                    this.checkForReferences(propKey, mo);
                }
                if ((ref = (ManagementObjectRef)pannotations.get(ManagementObjectRef.class.getName())) != null) {
                    String targetKey;
                    ManagedObject target;
                    Object refName;
                    if (trace) {
                        log.trace((Object)("Property(" + prop.getName() + ") references: " + ref));
                    }
                    if ((refName = this.getRefName(prop.getValue())) == null) {
                        refName = ref.name();
                    }
                    if ((target = this.moRegistry.get(targetKey = refName + "/" + ref.type())) != null) {
                        if (trace) {
                            log.trace((Object)("Resolved property(" + prop.getName() + ") reference to: " + targetKey));
                        }
                        prop.setTargetManagedObject(target);
                    } else {
                        Set<ManagedProperty> referers = this.unresolvedRefs.get(targetKey);
                        if (referers == null) {
                            referers = new HashSet<ManagedProperty>();
                            this.unresolvedRefs.put(targetKey, referers);
                        }
                        referers.add(prop);
                    }
                }
            }
            if ((propType = prop.getMetaType()) == AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) {
                this.processGenericValue((GenericValue)prop.getValue(), md, context);
                continue;
            }
            if (propType.isArray()) {
                amt = (ArrayMetaType)propType;
                etype = amt.getElementType();
                if (etype != AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) continue;
                avalue = (ArrayValue)prop.getValue();
                int length = avalue != null ? avalue.getLength() : 0;
                for (int n = 0; n < length; ++n) {
                    this.processGenericValue((GenericValue)avalue.getValue(n), md, context);
                }
                continue;
            }
            if (!propType.isCollection() || (etype = (amt = (CollectionMetaType)propType).getElementType()) != AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE || (avalue = (CollectionValue)prop.getValue()) == null) continue;
            MetaValue[] elements = avalue.getElements();
            for (int n = 0; n < avalue.getSize(); ++n) {
                this.processGenericValue((GenericValue)elements[n], md, context);
            }
        }
    }

    protected Object getRefName(Object value) {
        if (value instanceof MetaValue) {
            MetaValue metaValue = (MetaValue)MetaValue.class.cast(value);
            if (!metaValue.getMetaType().isSimple()) {
                throw new IllegalArgumentException("Can only get ref from simple value: " + value);
            }
            return ((SimpleValue)SimpleValue.class.cast(metaValue)).getValue();
        }
        return value;
    }

    protected void checkForReferences(String key, ManagedObject mo) {
        Set<ManagedProperty> referers = this.unresolvedRefs.get(key);
        log.trace((Object)("checkForReferences, " + key + " has referers: " + referers));
        if (referers != null) {
            for (ManagedProperty prop : referers) {
                prop.setTargetManagedObject(mo);
            }
            this.unresolvedRefs.remove(key);
        }
    }

    protected void processGenericValue(GenericValue genericValue, ManagedDeployment md, ProfileViewProcessingContext context) throws Exception {
        ManagedObject propMO;
        if (genericValue != null && (propMO = (ManagedObject)genericValue.getValue()) != null) {
            this.processManagedObject(propMO, md, context);
        }
    }

    protected <T> T getAnnotation(ManagedObject mo, Class<T> annotationType) {
        return annotationType.cast(mo.getAnnotations().get(annotationType.getName()));
    }
}

