/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.managed.api.ManagedProperty;

public class RemovedPropertyMap
implements Map<String, ManagedProperty> {
    private Map<String, ManagedProperty> delegate;
    private Set<String> keySet;

    public RemovedPropertyMap(Map<String, ManagedProperty> delegate) {
        this.delegate = delegate;
        this.keySet = new HashSet<String>();
        for (String key : delegate.keySet()) {
            ManagedProperty mp = delegate.get(key);
            if (mp == null || mp.isRemoved()) continue;
            this.keySet.add(key);
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.keySet.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        ManagedProperty mp = (ManagedProperty)value;
        return this.keySet.contains(mp.getName());
    }

    @Override
    public Set<Map.Entry<String, ManagedProperty>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.delegate).equals(o);
    }

    @Override
    public ManagedProperty get(Object key) {
        ManagedProperty mp = this.delegate.get(key);
        if (mp != null && mp.isRemoved()) {
            mp = null;
        }
        return mp;
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.keySet.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.keySet;
    }

    @Override
    public ManagedProperty put(String key, ManagedProperty value) {
        if (value.isRemoved()) {
            this.keySet.add(key);
        }
        return this.delegate.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends ManagedProperty> t) {
        this.delegate.putAll(t);
    }

    @Override
    public ManagedProperty remove(Object key) {
        if (this.keySet.contains(key)) {
            this.keySet.remove(key);
        }
        return this.delegate.remove(key);
    }

    @Override
    public int size() {
        return this.keySet.size();
    }

    @Override
    public Collection<ManagedProperty> values() {
        ArrayList<ManagedProperty> values = new ArrayList<ManagedProperty>();
        for (ManagedProperty mp : this.delegate.values()) {
            if (mp.isRemoved()) continue;
            values.add(mp);
        }
        return values;
    }
}

