/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.profileservice.spi;

import java.io.Serializable;

import org.jboss.profileservice.spi.deployment.DeploymentAttachments;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentInfo;
import org.jboss.vfs.VirtualFile;

/**
 * The profile deployment.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 102120 $
 */
// TODO remove dependency on VFS
public interface ProfileDeployment extends Serializable
{

   /**
    * Get the deployment name
    * 
    * @return the name
    */
   String getName();
   
   /**
    * The simple deployment name.
    * 
    * @return the simple deployment name
    */
   String getSimpleName();

   /**
    * Get the deployment info.
    * 
    * @return the deployment info
    */
   ProfileDeploymentInfo getDeploymentInfo();
   
   /**
    * Get the root of the deployment
    * 
    * @return the deployment root, null if it's not a VFS based deployment
    */
   VirtualFile getRoot();

   /**
    * Get the predetermined attachments.
    * 
    * @return the predetermined attachments
    */
   DeploymentAttachments getPredeterminedAttachments();

   /**
    * Get the transient attachments. 
    * 
    * @return the transient attachments
    */
   DeploymentAttachments getTransientAttachments();

   /**
    * Cleanup the associated {@code VirtualFile} information.
    *
    * @throws Exception for any error
    */
   void cleanup() throws Exception;
   
}

