/*
* JBoss, Home of Professional Open Source
* Copyright 2009, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.spi.repository;


/**
 * The artifact repository configuration.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface ArtifactRepositoryConfiguration<T extends ArtifactId>
{
   
   /**
    * Returns <code>true</code> if this repository can be modified.
    * 
    * @return whether this repository is mutable or not
    */
   boolean isMutable();

   /**
    * Get the vfs backup policy.
    * 
    * @return the backup policy
    */
   VFSBackupPolicy getBackupPolicy();
   
   /**
    * Get the not found handler.
    * 
    * @return the not found handler.
    */
   ArtifactNotFoundHandler<T> getNotFoundHandler();

   /**
    * The repository backup policy. This is needed for any hot-deployment
    * profile using a artifact repository preserving the original view on
    * the file system.
    * 
    * For BACKUP the semantics are that all artifacts reference
    * the backup location, therefore the location of the {@code VirtualFile}
    * will be different from it's original root.
    * The original can be reconstructed using the {@code ArtifactRepository#getRepositoryURI()}
    * and the {@code Artifact#getRelativePath()}.
    *
    * USE_ORIGINAL will return the real location, where the actual view on the virtual file
    * system can change during the deployment process.
    * 
    */
   public enum VFSBackupPolicy
   {
      // return a backup artifact
      BACKUP,
      
      // return the original file
      ORIGINAL,
   }
   
}

