/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.deployers.spi.management;

import java.util.Map;

/**
 * Basic state mapper.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 103418 $
 */
public abstract class ContextStateMapper<T extends Enum<?>>
{
   
   /** The state mappings. */
   protected final Map<String, T> mappings;
   
   /** Installing state. */
   protected final T installState;
   
   /** Uninstalling state. */
   protected final T uninstallState;
   
   /** The unknown state. */
   protected final T unknown;
   
   /** The error state. */
   protected final T error;

   public ContextStateMapper(Map<String, T> mappings,
         T installState, T uninstallState, T error, T unknown)
   {
      this.mappings = mappings;
      this.installState = installState;
      this.uninstallState = uninstallState;
      this.error = error;
      this.unknown = unknown;
   }
   
   public T getErrorState()
   {
      return this.error;
   }
   
   public abstract T map(String currentState, String toState);
   
   public T getinstallingState()
   {
      return installState;
   }
   
   public T getUninstallingState()
   {
      return uninstallState;
   }
   
   public T getUnknownState()
   {
      return unknown;
   }
   
   protected T getMapping(String controllerState)
   {
      T state = unknown;
      if(controllerState != null)
       state = mappings.get(controllerState);
      return state;
   }
   
}
