/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.deployers.spi.management.deploy;

import org.jboss.profileservice.spi.DeploymentOption;

/**
 * The deployment options.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 92346 $
 */
public interface DeploymentOptions
{
   
   /**
    * Add a deployment option.
    * 
    * @param option the option
    */
   void addDeploymentOption(DeploymentOption option);
   
   /**
    * Remove a deployment option.
    * 
    * @param option the option
    * @return true, if the option was present 
    */
   boolean removeDeploymentOption(DeploymentOption option);
   
   /**
    * Has a given deployment option.
    * 
    * @param option the deployment option
    * @return true, if the option is set
    */
   boolean hasDeploymentOption(DeploymentOption option);
   
   /**
    * Get all deployment options.
    * 
    * @return the set deployment option
    */
   DeploymentOption[] getDeploymentOptions();

}

