/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.profileservice.spi.dependency;

/**
 * The profile capability.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 101127 $
 */
public interface ProfileCapability
{

   /**
    * Try to resolve a profile requirement.
    * 
    * @param the profile requirement
    * @return true if the capability resolves the given requirement, otherwise false.
    */
   boolean resolves(ProfileRequirement requirement);

   /**
    * Check whether this capability is consistent with another capability.<p>
    *
    * Since the capabilties are within one shared 'domain' capabilties have to 
    * be unique.
    * 
    * @param other the other capability
    * @return true when consistent, false when inconsistent
    */
   boolean isConsistent(ProfileCapability other);
   
}

