/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.fuse.strategy.command;

import org.jboss.qa.jcontainer.fuse.FuseClient;
import org.jboss.qa.jcontainer.fuse.FuseConfiguration;
import org.jboss.qa.jcontainer.fuse.strategy.command.FuseCommandStrategy;
import org.jboss.qa.jcontainer.fuse.strategy.command.impl.Fuse6CommandStrategy;
import org.jboss.qa.jcontainer.fuse.strategy.command.impl.Fuse7CommandStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuseCommandFactory {
    private static final Logger log = LoggerFactory.getLogger(FuseCommandFactory.class);
    private FuseCommandStrategy strategy;
    private static final String FUSE_7_KARAF_VERSION_PREFIX = "4";

    public FuseCommandFactory(FuseClient client) {
        this.initStrategy(client);
    }

    private void initStrategy(FuseClient<FuseConfiguration> client) {
        int version = ((FuseConfiguration)client.getConfiguration()).getVersion();
        if (version == -1) {
            try {
                client.execute("version");
                String karafVersionResult = client.getCommandResult();
                version = karafVersionResult.startsWith(FUSE_7_KARAF_VERSION_PREFIX) ? 7 : 6;
                log.debug("Detected version of Fuse: {}", (Object)version);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        switch (version) {
            case 6: {
                this.strategy = new Fuse6CommandStrategy();
                break;
            }
            case 7: {
                this.strategy = new Fuse7CommandStrategy();
                break;
            }
            default: {
                this.strategy = new Fuse6CommandStrategy();
            }
        }
    }

    public FuseCommandStrategy getStrategy() {
        return this.strategy;
    }
}

