/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.wildfly;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.qa.jcontainer.Configuration;

public class WildflyConfiguration
extends Configuration {
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final int DEFAULT_MANAGEMENT_PORT = 9990;
    protected final int httpPort;
    protected final int managementPort;
    protected final String profile;
    protected final Mode mode;
    protected final File script;

    protected WildflyConfiguration(Builder<?> builder) {
        super(builder);
        this.httpPort = builder.httpPort;
        this.managementPort = builder.managementPort;
        this.profile = builder.profile;
        this.mode = builder.mode;
        this.script = builder.script;
        this.envProps.put("LAUNCH_JBOSS_IN_BACKGROUND", "true");
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public String getProfile() {
        return this.profile;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getManagementPort() {
        return this.managementPort;
    }

    public Mode getMode() {
        return this.mode;
    }

    public File getBaseDir() {
        String modeVal = this.mode != null ? this.mode.getValue() : Mode.STANDALONE.getValue();
        return new File(this.directory, modeVal);
    }

    public File getConfigurationFolder() {
        return new File(this.getBaseDir(), "configuration");
    }

    public List<String> generateCommand() {
        if (!this.script.exists()) {
            throw new IllegalStateException(String.format("Script '%s' does not exist", this.script.getAbsolutePath()));
        }
        ArrayList<String> cmd = new ArrayList<String>();
        if (SystemUtils.IS_OS_WINDOWS) {
            cmd.add("cmd");
            cmd.add("/c");
            cmd.add(this.script.getAbsolutePath());
        } else {
            cmd.add("bash");
            cmd.add(this.script.getAbsolutePath());
        }
        cmd.add("-c");
        cmd.add(this.profile);
        return cmd;
    }

    public int getBusyPort() {
        return this.managementPort;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Configuration.Builder<T> {
        protected int httpPort;
        protected int managementPort;
        protected String profile;
        protected Mode mode;
        protected File script;

        public Builder() {
            this.xms = "64m";
            this.xmx = "512m";
            this.maxPermSize = "256m";
            this.httpPort = 8080;
            this.managementPort = 9990;
            this.profile = "standalone.xml";
            this.mode = Mode.STANDALONE;
            this.logFileName = "server.log";
        }

        public T httpPort(int httpPort) {
            this.httpPort = httpPort;
            return (T)((Object)((Builder)this.self()));
        }

        public T managementPort(int managementPort) {
            this.managementPort = managementPort;
            return (T)((Object)((Builder)this.self()));
        }

        public T profile(String profile) {
            this.profile = profile;
            return (T)((Object)((Builder)this.self()));
        }

        public T mode(Mode mode) {
            this.mode = mode;
            return (T)((Object)((Builder)this.self()));
        }

        public T adminOnly() {
            this.param("--admin-only");
            return (T)((Object)((Builder)this.self()));
        }

        public WildflyConfiguration build() {
            this.script = this.mode.equals((Object)Mode.STANDALONE) ? new File(this.directory, "bin" + File.separator + (SystemUtils.IS_OS_WINDOWS ? "standalone.bat" : "standalone.sh")) : new File(this.directory, "bin" + File.separator + (SystemUtils.IS_OS_WINDOWS ? "domain.bat" : "domain.sh"));
            StringBuffer javaOpts = new StringBuffer();
            if (!StringUtils.isEmpty((CharSequence)this.xms)) {
                javaOpts.append(" -Xms" + this.xms);
            }
            if (!StringUtils.isEmpty((CharSequence)this.xmx)) {
                javaOpts.append(" -Xmx" + this.xmx);
            }
            if (!StringUtils.isEmpty((CharSequence)this.permSize)) {
                javaOpts.append(" -XX:PermSize=" + this.permSize);
            }
            if (!StringUtils.isEmpty((CharSequence)this.maxPermSize)) {
                javaOpts.append(" -XX:MaxPermSize=" + this.maxPermSize);
            }
            javaOpts.append(" -Djava.net.preferIPv4Stack=true");
            javaOpts.append(" -Djboss.modules.system.pkgs=org.jboss.byteman");
            javaOpts.append(" -Djava.awt.headless=true");
            javaOpts.append(" -Djboss.management.http.port=" + this.managementPort);
            javaOpts.append(" -Djboss.http.port=" + this.httpPort);
            this.envProps.put("JAVA_OPTS", javaOpts.toString());
            return new WildflyConfiguration(this);
        }
    }

    public static enum Mode {
        STANDALONE("standalone"),
        DOMAIN("domain");

        private final String mode;

        private Mode(String mode) {
            this.mode = mode;
        }

        public String getValue() {
            return this.mode;
        }
    }
}

