/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.wildfly;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.qa.jcontainer.Configuration;

public class WildflyConfiguration
extends Configuration {
    public static final int DEFAULT_PORT_OFFSET = 0;
    public static final int DEFAULT_MANAGEMENT_PORT = 9990;
    protected final int portOffset;
    protected final String profile;
    protected final Mode mode;
    protected final File baseDir;
    protected final File script;

    protected WildflyConfiguration(Builder<?> builder) {
        super(builder);
        this.portOffset = builder.portOffset;
        this.profile = builder.profile;
        this.mode = builder.mode;
        this.baseDir = builder.baseDir;
        this.script = builder.script;
        this.envProps.put("LAUNCH_JBOSS_IN_BACKGROUND", "true");
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public File getBaseDir() {
        return this.baseDir != null ? this.baseDir : new File(this.baseDir, Mode.STANDALONE.getValue());
    }

    public File getConfigurationFolder() {
        return new File(this.getBaseDir(), "configuration");
    }

    public List<String> generateCommand() {
        if (!this.script.exists()) {
            throw new IllegalStateException(String.format("Script '%s' does not exist", this.script.getAbsolutePath()));
        }
        ArrayList<String> cmd = new ArrayList<String>();
        if (SystemUtils.IS_OS_WINDOWS) {
            cmd.add("cmd");
            cmd.add("/c");
            cmd.add(this.script.getAbsolutePath());
        } else {
            cmd.add("bash");
            cmd.add(this.script.getAbsolutePath());
        }
        cmd.add("-c");
        cmd.add(this.profile);
        return cmd;
    }

    public int getBusyPort() {
        return this.getManagementPort();
    }

    public int getManagementPort() {
        return 9990 + this.portOffset;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public String getProfile() {
        return this.profile;
    }

    public Mode getMode() {
        return this.mode;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Configuration.Builder<T> {
        protected int portOffset;
        protected String profile;
        protected Mode mode;
        protected File baseDir;
        protected File script;

        public Builder() {
            this.xms = "64m";
            this.xmx = "512m";
            this.maxPermSize = "256m";
            this.portOffset = 0;
            this.profile = "standalone.xml";
            this.mode = Mode.STANDALONE;
            this.logFileName = "server.log";
        }

        public T portOffset(int portOffset) {
            this.portOffset = portOffset;
            return (T)((Object)((Builder)this.self()));
        }

        public T baseDir(File baseDir) {
            this.baseDir = baseDir;
            return (T)((Object)((Builder)this.self()));
        }

        public T profile(String profile) {
            this.profile = profile;
            return (T)((Object)((Builder)this.self()));
        }

        public T mode(Mode mode) {
            this.mode = mode;
            return (T)((Object)((Builder)this.self()));
        }

        public T adminOnly() {
            this.param("--admin-only");
            return (T)((Object)((Builder)this.self()));
        }

        public WildflyConfiguration build() {
            this.script = this.mode.equals((Object)Mode.STANDALONE) ? new File(this.directory, "bin" + File.separator + (SystemUtils.IS_OS_WINDOWS ? "standalone.bat" : "standalone.sh")) : new File(this.directory, "bin" + File.separator + (SystemUtils.IS_OS_WINDOWS ? "domain.bat" : "domain.sh"));
            StringBuffer javaOpts = new StringBuffer();
            if (!StringUtils.isEmpty((CharSequence)this.xms)) {
                javaOpts.append(" -Xms").append(this.xms);
            }
            if (!StringUtils.isEmpty((CharSequence)this.xmx)) {
                javaOpts.append(" -Xmx").append(this.xmx);
            }
            if (!StringUtils.isEmpty((CharSequence)this.permSize)) {
                javaOpts.append(" -XX:PermSize=").append(this.permSize);
            }
            if (!StringUtils.isEmpty((CharSequence)this.maxPermSize)) {
                javaOpts.append(" -XX:MaxPermSize=").append(this.maxPermSize);
            }
            javaOpts.append(" -Djava.net.preferIPv4Stack=true");
            javaOpts.append(" -Djboss.modules.system.pkgs=org.jboss.byteman");
            javaOpts.append(" -Djava.awt.headless=true");
            javaOpts.append(" -Djboss.socket.binding.port-offset=").append(this.portOffset);
            if (this.baseDir != null) {
                javaOpts.append(" -Djboss.server.base.dir=").append(this.baseDir);
            }
            this.envProps.put("JAVA_OPTS", javaOpts.toString());
            return new WildflyConfiguration(this);
        }
    }

    public static enum Mode {
        STANDALONE("standalone"),
        DOMAIN("domain");

        private final String mode;

        private Mode(String mode) {
            this.mode = mode;
        }

        public String getValue() {
            return this.mode;
        }
    }
}

