/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.wildfly;

import java.io.File;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.qa.jcontainer.AbstractContainer;
import org.jboss.qa.jcontainer.util.ProcessUtils;
import org.jboss.qa.jcontainer.wildfly.WildflyClient;
import org.jboss.qa.jcontainer.wildfly.WildflyConfiguration;
import org.jboss.qa.jcontainer.wildfly.WildflyUser;
import org.jboss.qa.jcontainer.wildfly.utils.CoreUtils;

public class WildflyContainer<T extends WildflyConfiguration, U extends WildflyClient<T>, V extends WildflyUser>
extends AbstractContainer<T, U, V> {
    public WildflyContainer(T configuration) {
        super(configuration);
    }

    public void addUser(V user) throws Exception {
        File rolesFile;
        File usersFile;
        if (((WildflyUser)((Object)user)).getRealm() == null) {
            ((WildflyUser)((Object)user)).setRealm(WildflyUser.Realm.MANAGEMENT_REALM);
        }
        this.checkMandatoryProperty("username", user.getUsername());
        this.checkMandatoryProperty("password", user.getUsername());
        if (((WildflyUser)((Object)user)).getRealm().equals((Object)WildflyUser.Realm.APPLICATION_REALM)) {
            usersFile = new File(((WildflyConfiguration)this.configuration).getConfigurationFolder(), "application-users.properties");
            rolesFile = new File(((WildflyConfiguration)this.configuration).getConfigurationFolder(), "application-roles.properties");
        } else {
            usersFile = new File(((WildflyConfiguration)this.configuration).getConfigurationFolder(), "mgmt-users.properties");
            rolesFile = new File(((WildflyConfiguration)this.configuration).getConfigurationFolder(), "mgmt-groups.properties");
        }
        PropertiesConfiguration propConfUsers = new PropertiesConfiguration(usersFile);
        propConfUsers.setProperty(user.getUsername(), (Object)DigestUtils.md5Hex((String)String.format("%s:%s:%s", user.getUsername(), ((WildflyUser)((Object)user)).getRealm().getValue(), user.getPassword())));
        propConfUsers.save();
        PropertiesConfiguration propConfRoles = new PropertiesConfiguration(rolesFile);
        propConfRoles.setProperty(user.getUsername(), (Object)StringUtils.join((Iterable)user.getRoles(), (String)","));
        propConfRoles.save();
    }

    protected String getBasicCommand() {
        return ":whoami";
    }

    public synchronized void start() throws Exception {
        super.start();
        if (SystemUtils.IS_OS_WINDOWS) {
            this.addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    ProcessUtils.killJavaByContainerId((long)WildflyContainer.this.getId());
                }
            }));
        }
        if (SystemUtils.IS_OS_MAC) {
            this.addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    ProcessUtils.killAllJavaContainerProcesses((long)WildflyContainer.this.getId());
                }
            }));
        }
    }

    public File getLogDirInternal() {
        return new File(CoreUtils.getSystemProperty((WildflyClient)this.client, "jboss.server.log.dir"));
    }
}

